/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.factory.AbstractChangeRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.web.server.ServerWebExchange;

public class RequestHeaderToRequestUriGatewayFilterFactory
extends AbstractChangeRequestUriGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    private final Logger log = LoggerFactory.getLogger(RequestHeaderToRequestUriGatewayFilterFactory.class);

    public RequestHeaderToRequestUriGatewayFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name");
    }

    @Override
    protected Optional<URI> determineRequestUri(ServerWebExchange exchange, AbstractGatewayFilterFactory.NameConfig config) {
        String requestUrl = exchange.getRequest().getHeaders().getFirst(config.getName());
        return Optional.ofNullable(requestUrl).map(url -> {
            try {
                return new URL((String)url).toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                this.log.info("Request url is invalid : url={}, error={}", (Object)requestUrl, (Object)e.getMessage());
                return null;
            }
        });
    }
}

