/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.udp.UdpResources;
import reactor.netty.udp.UdpServer;

final class UdpServerBind
extends UdpServer {
    static final UdpServerBind INSTANCE = new UdpServerBind();

    UdpServerBind() {
    }

    @Override
    protected Mono<? extends Connection> bind(Bootstrap b) {
        if (b.config().group() == null) {
            UdpResources loopResources = UdpResources.get();
            EventLoopGroup elg = loopResources.onClient(LoopResources.DEFAULT_NATIVE);
            ((Bootstrap)b.group(elg)).channel(loopResources.onDatagramChannel(elg));
        }
        return ConnectionProvider.newConnection().acquire(b);
    }
}

