/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class MimeTypesUtils {
    private static final Pattern COMMA_SPLITTER = Pattern.compile(" *, *");
    private static final Pattern SEMICOLON_SPLITTER = Pattern.compile(" *; *");
    private static final Pattern EQUAL_SPLITTER = Pattern.compile(" *= *");
    private static final Comparator<String> ACCEPT_X_COMPARATOR = new Comparator<String>(){

        float getQuality(String s) {
            if (s == null) {
                return 0.0f;
            }
            String[] params = SEMICOLON_SPLITTER.split(s);
            for (int i = 1; i < params.length; ++i) {
                String[] q = EQUAL_SPLITTER.split(params[1]);
                if (!"q".equals(q[0])) continue;
                return Float.parseFloat(q[1]);
            }
            return 1.0f;
        }

        @Override
        public int compare(String o1, String o2) {
            float f1 = this.getQuality(o1);
            float f2 = this.getQuality(o2);
            return Float.compare(f2, f1);
        }
    };

    public static List<String> getSortedAcceptableMimeTypes(String acceptHeader) {
        if (acceptHeader == null) {
            return Collections.emptyList();
        }
        String[] items = COMMA_SPLITTER.split(acceptHeader);
        Arrays.sort(items, ACCEPT_X_COMPARATOR);
        ArrayList<String> list = new ArrayList<String>(items.length);
        for (String item : items) {
            int space = item.indexOf(59);
            if (space != -1) {
                list.add(item.substring(0, space));
                continue;
            }
            list.add(item);
        }
        return list;
    }
}

