/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.servo;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.metrics.servo.ServoMetricsConfigBean;

public class ServoMonitorCache {
    private static final Log log = LogFactory.getLog(ServoMonitorCache.class);
    private final Map<MonitorConfig, BasicTimer> timerCache = new HashMap<MonitorConfig, BasicTimer>();
    private final MonitorRegistry monitorRegistry;
    private final ServoMetricsConfigBean config;

    public ServoMonitorCache(MonitorRegistry monitorRegistry, ServoMetricsConfigBean config) {
        this.monitorRegistry = monitorRegistry;
        this.config = config;
    }

    public synchronized BasicTimer getTimer(MonitorConfig config) {
        BasicTimer t = this.timerCache.get(config);
        if (t != null) {
            return t;
        }
        t = new BasicTimer(config);
        this.timerCache.put(config, t);
        if (this.timerCache.size() > this.config.getCacheWarningThreshold()) {
            log.warn((Object)("timerCache is above the warning threshold of " + this.config.getCacheWarningThreshold() + " with size " + this.timerCache.size() + "."));
        }
        this.monitorRegistry.register((Monitor)t);
        return t;
    }
}

