/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.annotation;

import io.swagger.models.Swagger;
import java.util.Arrays;
import org.apache.servicecomb.swagger.generator.core.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMappingClassAnnotationProcessor
implements ClassAnnotationProcessor {
    public void process(Object annotation, SwaggerGenerator swaggerGenerator) {
        RequestMapping requestMapping = (RequestMapping)annotation;
        Swagger swagger = swaggerGenerator.getSwagger();
        this.processMethod(requestMapping.method(), swaggerGenerator);
        this.processPath(requestMapping.path(), swaggerGenerator);
        this.processPath(requestMapping.value(), swaggerGenerator);
        this.processConsumes(requestMapping.consumes(), swagger);
        this.processProduces(requestMapping.produces(), swagger);
    }

    protected void processPath(String[] paths, SwaggerGenerator swaggerGenerator) {
        if (null == paths || paths.length == 0) {
            return;
        }
        if (paths.length > 1) {
            throw new Error("not support multi path for " + swaggerGenerator.getCls().getName());
        }
        swaggerGenerator.setBasePath(paths[0]);
    }

    protected void processMethod(RequestMethod[] requestMethods, SwaggerGenerator swaggerGenerator) {
        if (null == requestMethods || requestMethods.length == 0) {
            return;
        }
        if (requestMethods.length > 1) {
            throw new Error("not allowed multi http method for " + swaggerGenerator.getCls().getName());
        }
        swaggerGenerator.setHttpMethod(requestMethods[0].name());
    }

    private void processConsumes(String[] consumes, Swagger swagger) {
        if (null == consumes || consumes.length == 0) {
            return;
        }
        swagger.setConsumes(Arrays.asList(consumes));
    }

    protected void processProduces(String[] produces, Swagger swagger) {
        if (null == produces || produces.length == 0) {
            return;
        }
        swagger.setProduces(Arrays.asList(produces));
    }
}

