/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.ucar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.Axis;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.ucar.DecoderWrapper;
import org.apache.sis.storage.netcdf.ucar.DimensionWrapper;
import org.apache.sis.storage.netcdf.ucar.VariableWrapper;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;

final class GridWrapper
extends Grid {
    private final CoordinateSystem netcdfCS;
    private final List<Dimension> domain;
    private final Map<List<Dimension>, GridWrapper> reordered;

    GridWrapper(CoordinateSystem cs) {
        this.netcdfCS = cs;
        this.reordered = new HashMap<List<Dimension>, GridWrapper>(4);
        this.domain = new ArrayList<Dimension>((Collection<Dimension>)cs.getDomain());
        HashMap<Dimension, AxisType> types = new HashMap<Dimension, AxisType>();
        for (CoordinateAxis axis : cs.getCoordinateAxes()) {
            Dimension dim;
            AxisType type = axis.getAxisType();
            UnmodifiableIterator unmodifiableIterator = axis.getDimensions().iterator();
            while (unmodifiableIterator.hasNext() && types.putIfAbsent(dim = (Dimension)unmodifiableIterator.next(), type) != null) {
            }
        }
        this.domain.sort((d1, d2) -> {
            AxisType t2;
            AxisType t1 = (AxisType)types.get(d1);
            if (t1 == (t2 = (AxisType)types.get(d2))) {
                return 0;
            }
            if (t1 == null) {
                return 1;
            }
            if (t2 == null) {
                return -1;
            }
            return t1.axisOrder() - t2.axisOrder();
        });
    }

    private GridWrapper(GridWrapper parent, List<Dimension> dimensions) {
        this.netcdfCS = parent.netcdfCS;
        this.reordered = parent.reordered;
        this.domain = dimensions;
        assert (this.netcdfCS.getDomain().containsAll(dimensions));
    }

    @Override
    protected Grid forDimensions(org.apache.sis.storage.netcdf.base.Dimension[] dimensions) {
        return this.forDimensions((List<Dimension>)UnmodifiableArrayList.wrap((Object[])DimensionWrapper.unwrap(dimensions)));
    }

    private GridWrapper forDimensions(List<Dimension> dimensions) {
        if (dimensions.size() > this.domain.size()) {
            dimensions = new ArrayList<Dimension>(dimensions);
            dimensions.retainAll(this.domain);
        }
        if (this.domain.equals(dimensions)) {
            return this;
        }
        return this.reordered.computeIfAbsent(dimensions, k -> {
            if (this.domain.size() == k.size() && this.domain.containsAll((Collection<?>)k)) {
                return new GridWrapper(this, (List<Dimension>)k);
            }
            return null;
        });
    }

    final GridWrapper forVariable(Variable variable, List<CoordinateSystem> systems, String[] axisNames) {
        if (systems.contains(this.netcdfCS) && this.containsAllNamedAxes(axisNames)) {
            return this.forDimensions((List<Dimension>)variable.getDimensions());
        }
        return null;
    }

    @Override
    public String getName() {
        return this.netcdfCS.getName();
    }

    @Override
    public int getSourceDimensions() {
        return this.netcdfCS.getRankDomain();
    }

    @Override
    protected List<org.apache.sis.storage.netcdf.base.Dimension> getDimensions() {
        return DimensionWrapper.wrap(this.domain);
    }

    @Override
    protected boolean containsAllNamedAxes(String[] axisNames) {
        if (axisNames != null) {
            block0: for (String name : axisNames) {
                for (CoordinateAxis axis : this.netcdfCS.getCoordinateAxes()) {
                    if (!name.equalsIgnoreCase(axis.getShortName())) continue;
                    continue block0;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Axis[] createAxes(Decoder decoder) throws IOException, DataStoreException {
        ImmutableList range = this.netcdfCS.getCoordinateAxes();
        int axisCount = 0;
        int targetDim = range.size();
        Object[] axes = new Axis[targetDim];
        while (--targetDim >= 0) {
            CoordinateAxis axis = (CoordinateAxis)range.get(targetDim);
            VariableWrapper wrapper = ((DecoderWrapper)decoder).getWrapperFor((Variable)axis);
            char abbreviation = '\u0000';
            AxisType type = axis.getAxisType();
            if (type != null) {
                switch (type) {
                    case GeoX: {
                        abbreviation = this.netcdfCS.isGeoXY() ? (char)'E' : 'x';
                        break;
                    }
                    case GeoY: {
                        abbreviation = this.netcdfCS.isGeoXY() ? (char)'N' : 'y';
                        break;
                    }
                    case GeoZ: {
                        abbreviation = this.netcdfCS.isGeoXY() ? (char)'H' : 'z';
                        break;
                    }
                    case Lon: {
                        abbreviation = '\u03bb';
                        break;
                    }
                    case Lat: {
                        abbreviation = '\u03c6';
                        break;
                    }
                    case Pressure: 
                    case Height: {
                        abbreviation = 'H';
                        break;
                    }
                    case RunTime: 
                    case Time: {
                        abbreviation = 't';
                        break;
                    }
                    case RadialAzimuth: {
                        abbreviation = '\u03b8';
                        break;
                    }
                    case RadialElevation: {
                        abbreviation = '\u03a9';
                        break;
                    }
                    case RadialDistance: {
                        abbreviation = 'r';
                    }
                }
            }
            if (abbreviation == '\u0000') {
                abbreviation = org.apache.sis.storage.netcdf.base.AxisType.abbreviation(wrapper, true);
            }
            int i = 0;
            ImmutableList axisDomain = axis.getDimensions();
            int[] indices = new int[axisDomain.size()];
            int[] sizes = new int[indices.length];
            for (Dimension dimension : axisDomain) {
                int sourceDim = this.domain.lastIndexOf(dimension);
                if (sourceDim < 0) continue;
                indices[i] = sourceDim;
                sizes[i++] = dimension.getLength();
            }
            if (i == 0) continue;
            axes[axisCount++] = new Axis(abbreviation, axis.getPositive(), indices, sizes, i, wrapper);
        }
        return (Axis[])ArraysExt.resize((Object[])axes, (int)axisCount);
    }
}

