/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.MatrixParameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.EPSGName;
import org.apache.sis.referencing.operation.provider.FormulaCategory;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.SingleOperation;

@XmlTransient
public final class Affine
extends AbstractProvider {
    private static final long serialVersionUID = 6001828063655967608L;
    private static final int CODE = 9624;
    public static final String NAME = "Affine parametric transformation";
    public static final int EPSG_DIMENSION = 2;
    private static final int MAX_CACHED_DIMENSION = 6;
    private static final Affine[] CACHED = new Affine[36];
    private static final NamedIdentifier IDENTIFICATION_OGC = new NamedIdentifier((Citation)Citations.OGC, "OGC", (CharSequence)"Affine", null, null);
    private static final Affine EPSG_METHOD = new Affine();

    public static Affine provider() {
        return EPSG_METHOD;
    }

    public Affine() {
        this(EPSGName.properties(9624, NAME, IDENTIFICATION_OGC), Affine.descriptors());
    }

    private static ParameterDescriptor<?>[] descriptors() {
        ParameterDescriptor<?>[] descriptors = MatrixParameters.EPSG.getAllDescriptors(2, 3);
        return new ParameterDescriptor[]{descriptors[4], descriptors[2], descriptors[3], descriptors[7], descriptors[5], descriptors[6]};
    }

    private Affine(Map<String, ?> properties, ParameterDescriptor<?>[] parameters) {
        super(SingleOperation.class, new Descriptor(properties, parameters), CoordinateSystem.class, false, CoordinateSystem.class, false, (byte)1);
    }

    private static MatrixParameters<Double> convention(IdentifiedObject object) {
        return EPSGName.isCodeEquals(object, 9624) || IdentifiedObjects.isHeuristicMatchForName(object, NAME) ? MatrixParameters.EPSG : MatrixParameters.WKT1;
    }

    @Override
    public AbstractProvider variantFor(MathTransform transform) {
        boolean isAffine = transform instanceof LinearTransform && ((LinearTransform)transform).isAffine();
        return Affine.provider(transform.getSourceDimensions(), transform.getTargetDimensions(), isAffine);
    }

    @Override
    public FormulaCategory getFormulaCategory() {
        return FormulaCategory.APPLIED_VERBATIM;
    }

    @Override
    public AbstractProvider inverse() {
        return this;
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) {
        ParameterValueGroup parameters = context.getCompletedParameters();
        return MathTransforms.linear(Affine.convention((IdentifiedObject)parameters.getDescriptor()).toMatrix(parameters));
    }

    private static int cacheIndex(int sourceDimensions, int targetDimensions) {
        if (--sourceDimensions >= 0 && sourceDimensions < 6 && --targetDimensions >= 0 && targetDimensions < 6) {
            return sourceDimensions * 6 + targetDimensions;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Affine provider(int sourceDimensions, int targetDimensions, boolean isAffine) {
        Affine method;
        if (isAffine && sourceDimensions == 2 && targetDimensions == 2) {
            return EPSG_METHOD;
        }
        int index = Affine.cacheIndex(sourceDimensions, targetDimensions);
        if (index >= 0) {
            Affine[] affineArray = CACHED;
            // MONITORENTER : CACHED
            method = CACHED[index];
            // MONITOREXIT : affineArray
            if (method != null) {
                return method;
            }
        }
        ParameterDescriptor<?>[] parameters = MatrixParameters.WKT1.getAllDescriptors(targetDimensions + 1, sourceDimensions + 1);
        method = new Affine(Map.of("name", IDENTIFICATION_OGC), parameters);
        if (index < 0) return method;
        Affine[] affineArray = CACHED;
        // MONITORENTER : CACHED
        Affine other = CACHED[index];
        if (other != null) {
            // MONITOREXIT : affineArray
            return other;
        }
        Affine.CACHED[index] = method;
        // MONITOREXIT : affineArray
        return method;
    }

    public static ParameterValueGroup identity(int dimension) {
        ParameterValueGroup values = MatrixParameters.WKT1.createValueGroup(Map.of("name", "Affine"));
        values.parameter("num_col").setValue(++dimension);
        values.parameter("num_row").setValue(dimension);
        return values;
    }

    public static ParameterValueGroup parameters(Matrix matrix) {
        return MatrixParameters.WKT1.createValueGroup(Map.of("name", IDENTIFICATION_OGC), matrix);
    }

    private static final class Descriptor
    extends DefaultParameterDescriptorGroup {
        private static final long serialVersionUID = 8320799650519834830L;

        Descriptor(Map<String, ?> properties, ParameterDescriptor<?>[] parameters) {
            super(properties, 1, 1, (GeneralParameterDescriptor[])parameters);
        }

        @Override
        public ParameterValueGroup createValue() {
            return Affine.convention(this).createValueGroup(Map.of("name", this.getName()));
        }
    }
}

