/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.XmlElement;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.temporal.TemporalObjects;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.apache.sis.xml.bind.gml.TimeInstant;
import org.apache.sis.xml.bind.gml.TimePeriod;
import org.apache.sis.xml.bind.gml.TimePeriodBound;
import org.apache.sis.xml.internal.shared.XmlUtilities;
import org.opengis.temporal.TemporalPrimitive;

public class TM_Primitive
extends PropertyType<TM_Primitive, TemporalPrimitive> {
    public TM_Primitive() {
    }

    private TM_Primitive(TemporalPrimitive metadata) {
        super(metadata);
    }

    @Override
    protected TM_Primitive wrap(TemporalPrimitive value) {
        return new TM_Primitive(value);
    }

    @Override
    protected final Class<TemporalPrimitive> getBoundType() {
        return TemporalPrimitive.class;
    }

    @XmlElement(name="TimePeriod")
    public final TimePeriod getTimePeriod() {
        if (this.metadata instanceof Period) {
            return new TimePeriod((Period)this.metadata);
        }
        return null;
    }

    @XmlElement(name="TimeInstant")
    public final TimeInstant getTimeInstant() {
        Temporal time = TemporalObjects.getInstant((TemporalPrimitive)this.metadata);
        return time != null ? new TimeInstant(time) : null;
    }

    public final void setTimePeriod(TimePeriod period) {
        this.metadata = null;
        if (period != null) {
            Context context = Context.current();
            Temporal begin = TM_Primitive.toInstant(context, period.begin);
            Temporal end = TM_Primitive.toInstant(context, period.end);
            if (begin != null && end != null && end.isSupported(ChronoField.INSTANT_SECONDS) && begin.isSupported(ChronoField.INSTANT_SECONDS) && begin.getLong(ChronoField.INSTANT_SECONDS) > end.getLong(ChronoField.INSTANT_SECONDS)) {
                Context.warningOccured(context, TemporalPrimitive.class, "setTimePeriod", Errors.class, (short)76, begin, end);
            } else {
                this.metadata = TemporalObjects.createPeriod(begin, end);
                period.copyIdTo(this.metadata);
            }
        }
    }

    public final void setTimeInstant(TimeInstant instant) {
        Temporal position;
        this.metadata = null;
        if (instant != null && (position = XmlUtilities.toTemporal(Context.current(), instant.timePosition)) != null) {
            this.metadata = TemporalObjects.createInstant(position);
            instant.copyIdTo(this.metadata);
        }
    }

    private static Temporal toInstant(Context context, TimePeriodBound bound) {
        return bound != null ? XmlUtilities.toTemporal(context, bound.calendar()) : null;
    }

    public static final class Since2014
    extends TM_Primitive {
        @Override
        protected TM_Primitive wrap(TemporalPrimitive value) {
            return this.accept2014() ? super.wrap(value) : null;
        }
    }
}

