/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.processing.isoline;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.image.processing.isoline.Parallelized;
import org.apache.sis.image.processing.isoline.PolylineStage;
import org.apache.sis.image.processing.isoline.Result;
import org.apache.sis.image.processing.isoline.Tracer;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class Isolines {
    private final Tracer.Level[] levels;
    private static final BiConsumer<String, Isolines> LISTENER = null;

    private Isolines(Tracer tracer, int band, double[] values, int width) {
        this.levels = new Tracer.Level[values.length];
        for (int i = 0; i < values.length; ++i) {
            Tracer tracer2 = tracer;
            Objects.requireNonNull(tracer2);
            this.levels[i] = new Tracer.Level(tracer2, band, values[i], width);
        }
    }

    private static double[][] cloneAndSort(double[][] levels) {
        levels.clone();
        for (int j = 0; j < levels.length; ++j) {
            int n;
            double[] values = levels[j];
            ArgumentChecks.ensureNonNullElement((String)"levels", (int)j, (Object)values);
            values = (double[])values.clone();
            Arrays.sort(values);
            for (n = values.length; n > 0 && Double.isNaN(values[n - 1]); --n) {
            }
            int i = n;
            while (--i > 0) {
                if (values[i] != values[i - 1]) continue;
                System.arraycopy(values, i, values, i - 1, n-- - i);
            }
            levels[j] = ArraysExt.resize((double[])values, (int)n);
        }
        return levels;
    }

    private void setMaskBit(double value, int bit) {
        for (Tracer.Level level : this.levels) {
            if (level.value > value) break;
            level.isDataAbove |= bit;
        }
    }

    public static Isolines[] generate(RenderedImage data, double[][] levels, MathTransform gridToCRS) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"data", (Object)data);
        ArgumentChecks.ensureNonNull((String)"levels", (Object)levels);
        return Isolines.flush(Isolines.generate(Isolines.iterators().create(data), Isolines.cloneAndSort(levels), gridToCRS));
    }

    public static Future<Isolines[]> parallelGenerate(RenderedImage data, double[][] levels, MathTransform gridToCRS) {
        ArgumentChecks.ensureNonNull((String)"data", (Object)data);
        ArgumentChecks.ensureNonNull((String)"levels", (Object)levels);
        return new Parallelized(data, Isolines.cloneAndSort(levels), gridToCRS).execute();
    }

    static void merge(Isolines[] isolines, Isolines[] neighbor) throws TransformException {
        for (int i = 0; i < isolines.length; ++i) {
            Isolines target = isolines[i];
            Isolines source = neighbor[i];
            for (int j = 0; j < target.levels.length; ++j) {
                target.levels[j].merge(source.levels[j]);
            }
        }
    }

    static PixelIterator.Builder iterators() {
        return new PixelIterator.Builder().setIteratorOrder(SequenceType.LINEAR);
    }

    static Isolines[] flush(Isolines[] isolines) throws TransformException {
        for (Isolines isoline : isolines) {
            for (Tracer.Level level : isoline.levels) {
                level.flush();
            }
        }
        return isolines;
    }

    static Isolines[] generate(PixelIterator iterator, double[][] levels, MathTransform gridToCRS) throws TransformException {
        int b;
        int numBands = iterator.getNumBands();
        double[] window = new double[numBands * 4];
        Tracer tracer = new Tracer(window, numBands, iterator.getDomain(), gridToCRS);
        int width = iterator.getDomain().width - 1;
        Isolines[] isolines = new Isolines[numBands];
        double[] levelValues = ArraysExt.EMPTY_DOUBLE;
        for (int b2 = 0; b2 < numBands; ++b2) {
            if (b2 < levels.length) {
                levelValues = levels[b2];
                ArgumentChecks.ensureNonNullElement((String)"levels", (int)b2, (Object)levelValues);
                levelValues = (double[])levelValues.clone();
            }
            isolines[b2] = new Isolines(tracer, b2, levelValues, width);
        }
        double[] pixelValues = new double[numBands];
        double[] valuesOnPreviousRow = new double[numBands * (width + 1)];
        for (int i = 0; i < valuesOnPreviousRow.length; i += numBands) {
            if (!iterator.next()) {
                return isolines;
            }
            System.arraycopy(iterator.getPixel(pixelValues), 0, valuesOnPreviousRow, i, numBands);
        }
        int twoPixels = numBands * 2;
        int lastPixel = numBands * 3;
        block2: while (iterator.next()) {
            int b3;
            int flag;
            System.arraycopy(valuesOnPreviousRow, 0, window, 0, twoPixels);
            System.arraycopy(iterator.getPixel(pixelValues), 0, window, twoPixels, numBands);
            if (!iterator.next()) break;
            System.arraycopy(iterator.getPixel(pixelValues), 0, window, lastPixel, numBands);
            System.arraycopy(window, twoPixels, valuesOnPreviousRow, 0, twoPixels);
            int i22 = 0;
            for (flag = 1; flag <= 8; flag <<= 1) {
                for (b3 = 0; b3 < numBands; ++b3) {
                    isolines[b3].setMaskBit(window[i22++], flag);
                }
            }
            Isolines[] i22 = isolines;
            flag = i22.length;
            for (b3 = 0; b3 < flag; ++b3) {
                Isolines iso = i22[b3];
                Tracer.Level[] levelArray = iso.levels;
                int n = levelArray.length;
                for (int i = 0; i < n; ++i) {
                    Tracer.Level level = levelArray[i];
                    level.interpolate();
                }
            }
            tracer.x = 1;
            while (tracer.x < width) {
                int offsetOnPreviousRow = (tracer.x + 1) * numBands;
                if (!iterator.next()) break block2;
                if (numBands == 1) {
                    window[2] = window[3];
                    window[0] = window[1];
                    window[1] = valuesOnPreviousRow[offsetOnPreviousRow];
                    window[3] = valuesOnPreviousRow[offsetOnPreviousRow] = iterator.getSampleDouble(0);
                } else {
                    System.arraycopy(window, numBands, window, 0, numBands);
                    System.arraycopy(window, lastPixel, window, twoPixels, numBands);
                    System.arraycopy(valuesOnPreviousRow, offsetOnPreviousRow, window, numBands, numBands);
                    System.arraycopy(iterator.getPixel(pixelValues), 0, window, lastPixel, numBands);
                    System.arraycopy(window, lastPixel, valuesOnPreviousRow, offsetOnPreviousRow, numBands);
                }
                for (int b4 = 0; b4 < numBands; ++b4) {
                    Isolines iso = isolines[b4];
                    for (Tracer.Level level : iso.levels) {
                        level.nextColumn();
                    }
                    iso.setMaskBit(window[numBands + b4], 2);
                    iso.setMaskBit(window[lastPixel + b4], 8);
                    for (Tracer.Level level : iso.levels) {
                        level.interpolate();
                    }
                }
                ++tracer.x;
            }
            for (b = 0; b < numBands; ++b) {
                for (Tracer.Level level : isolines[b].levels) {
                    level.finishedRow();
                }
                if (LISTENER == null) continue;
                int y = tracer.y;
                int h = iterator.getDomain().height;
                LISTENER.accept(String.format("After row %d of %d (%3.1f%%)", y, h, Float.valueOf(100.0f * (float)y / (float)h)), isolines[b]);
            }
            tracer.x = 0;
            ++tracer.y;
        }
        for (b = 0; b < numBands; ++b) {
            for (Tracer.Level level : isolines[b].levels) {
                level.finish();
            }
            if (LISTENER == null) continue;
            LISTENER.accept("Finished band " + b, isolines[b]);
        }
        return isolines;
    }

    public final NavigableMap<Double, Shape> polylines() {
        TreeMap<Double, Shape> paths = new TreeMap<Double, Shape>();
        for (Tracer.Level level : this.levels) {
            Shape path = level.shape;
            if (path == null) continue;
            paths.put(level.value, path);
        }
        return paths;
    }

    static NavigableMap<Double, Shape>[] toArray(Isolines[] isolines) {
        NavigableMap[] result = new NavigableMap[isolines.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = isolines[i].polylines();
        }
        return result;
    }

    public static List<NavigableMap<Double, Shape>> toList(Isolines[] isolines) {
        return Arrays.asList(Isolines.toArray(isolines));
    }

    public static List<NavigableMap<Double, Shape>> toList(Future<Isolines[]> isolines) {
        return new Result(isolines);
    }

    final Map<PolylineStage, Path2D> toRawPath() {
        EnumMap<PolylineStage, Path2D> appendTo = new EnumMap<PolylineStage, Path2D>(PolylineStage.class);
        for (Tracer.Level level : this.levels) {
            level.toRawPath(appendTo);
        }
        return appendTo;
    }
}

