/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.stream;

import java.util.Spliterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.StreamSupport;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.stream.StreamWrapper;

public abstract class DeferredStream<T>
extends StreamWrapper<T> {
    private final CloseHandler closeHandler;

    protected DeferredStream(int characteristics, boolean parallel) {
        this.source = StreamSupport.stream(this::terminal, characteristics, parallel);
        this.closeHandler = new CloseHandler();
        this.source.onClose(this.closeHandler);
        this.toClose = this.source;
    }

    private Spliterator<T> terminal() {
        this.source = null;
        try {
            return this.createSourceIterator();
        }
        catch (Exception cause) {
            throw DeferredStream.cannotExecute(cause);
        }
    }

    protected abstract Spliterator<T> createSourceIterator() throws Exception;

    protected final void setCloseHandler(AutoCloseable handler) {
        this.closeHandler.handler = handler;
    }

    protected final void lock(ReadWriteLock lock) {
        if (lock != null) {
            this.closeHandler.lock = lock.readLock();
            this.closeHandler.lock.lock();
        }
    }

    protected final void unlock() {
        this.closeHandler.run();
    }

    public static RuntimeException cannotExecute(Exception cause) {
        Exception unwrap = Exceptions.unwrap((Exception)cause);
        if (unwrap instanceof RuntimeException) {
            return (RuntimeException)unwrap;
        }
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return new BackingStoreException(cause.toString(), (Throwable)unwrap);
    }

    private static final class CloseHandler
    implements Runnable {
        AutoCloseable handler;
        Lock lock;

        private CloseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                AutoCloseable h = this.handler;
                Lock c = this.lock;
                this.handler = null;
                this.lock = null;
                try {
                    if (h == null) break block6;
                    try {
                        h.close();
                    }
                    catch (Exception e) {
                        throw DeferredStream.cannotExecute(e);
                    }
                }
                finally {
                    if (c != null) {
                        c.unlock();
                    }
                }
            }
        }
    }
}

