/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import java.util.OptionalInt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.FactoryException;

public final class GeographicToGeocentric
extends AbstractProvider {
    private static final long serialVersionUID = -5690807111952562344L;
    public static final String NAME = "Ellipsoid_To_Geocentric";
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)GeographicToGeocentric.builder().addIdentifier("9602")).addName("Geographic/geocentric conversions")).addName((Citation)Citations.OGC, "Ellipsoid_To_Geocentric")).createGroupForMapProjection(new ParameterDescriptor[0]);

    public GeographicToGeocentric() {
        super(Conversion.class, PARAMETERS, EllipsoidalCS.class, true, CartesianCS.class, false, (byte)2);
    }

    @Override
    public String resolveAmbiguity(MathTransformProvider.Context context) {
        if (CartesianCS.class.isAssignableFrom(context.getSourceCSType()) && EllipsoidalCS.class.isAssignableFrom(context.getTargetCSType())) {
            return "Geocentric_To_Ellipsoid";
        }
        return super.resolveAmbiguity(context);
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        return GeographicToGeocentric.create(context, context.getSourceDimensions(), context.getTargetCSType());
    }

    static MathTransform create(MathTransformProvider.Context context, OptionalInt dimension, Class<? extends CoordinateSystem> geocentric) throws FactoryException {
        EllipsoidToCentricTransform.TargetType type;
        Parameters values = Parameters.castOrWrap(context.getCompletedParameters());
        if (geocentric == CoordinateSystem.class) {
            type = EllipsoidToCentricTransform.TargetType.CARTESIAN;
        } else {
            try {
                type = EllipsoidToCentricTransform.TargetType.of(geocentric);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidGeodeticParameterException(Resources.format((short)27), e);
            }
        }
        return EllipsoidToCentricTransform.createGeodeticConversion(context.getFactory(), MapProjection.getEllipsoid(values, context), dimension.orElse(3) >= 3, type);
    }
}

