/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui;

import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SlingIdePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ListEditor ignoredFileNamesForSyncEditor;

    public SlingIdePreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        this.ignoredFileNamesForSyncEditor = new ListEditor("ignoredFileNamesForSync", "Ignored file names for the server sync", this.getFieldEditorParent()){

            protected String createList(String[] items) {
                StringBuffer path = new StringBuffer("");
                int i = 0;
                while (i < items.length) {
                    path.append(items[i]);
                    path.append(";");
                    ++i;
                }
                return path.toString();
            }

            protected String getNewInputObject() {
                InputDialog dialog = new InputDialog(this.getShell(), "Add file name", "Enter a file name to ignore during the server sync ...", "", (IInputValidator)new PatternValidator());
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return null;
            }

            protected String[] parseString(String stringList) {
                return stringList.split(";");
            }
        };
        this.addField((FieldEditor)this.ignoredFileNamesForSyncEditor);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    private static final class PatternValidator
    implements IInputValidator {
        private PatternValidator() {
        }

        public String isValid(String newText) {
            if (newText.matches(".*(\\\\|\\/).*")) {
                return "Name must not contain '/' or ''";
            }
            return null;
        }
    }
}

