/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.spi.RootLogger;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DummyTopologyView;
import org.apache.sling.discovery.commons.providers.SimpleCommonsConfig;
import org.apache.sling.discovery.commons.providers.base.DummyListener;
import org.apache.sling.discovery.commons.providers.base.DummyScheduler;
import org.apache.sling.discovery.commons.providers.base.TestHelper;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerImpl;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.ClusterSyncServiceChain;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteConfig;
import org.apache.sling.discovery.commons.providers.spi.base.DummyClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.base.DummySlingSettingsService;
import org.apache.sling.discovery.commons.providers.spi.base.IdMapService;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOakViewStateManager
implements DiscoveryService {
    protected static final Logger logger = LoggerFactory.getLogger(TestOakViewStateManager.class);
    @Rule
    public final SlingContext context1 = new SlingContext();
    @Rule
    public final SlingContext context2 = new SlingContext();
    protected ViewStateManagerImpl mgr;
    private Level logLevel;
    private IdMapService idMapService1;
    private String slingId1;
    private Scheduler scheduler;
    private TopologyView view;

    @Before
    public void setup() throws Exception {
        logger.info("setup: start");
        this.mgr = new ViewStateManagerImpl((Lock)new ReentrantLock(), new ClusterSyncService(){

            public void sync(BaseTopologyView view, Runnable callback) {
                callback.run();
            }

            public void cancelSync() {
            }
        });
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        this.logLevel = discoveryLogger.getLevel();
        discoveryLogger.setLevel(Level.INFO);
        this.slingId1 = UUID.randomUUID().toString();
        this.idMapService1 = IdMapService.testConstructor((DiscoveryLiteConfig)new SimpleCommonsConfig(), (SlingSettingsService)new DummySlingSettingsService(this.slingId1), (ResourceResolverFactory)((ResourceResolverFactory)this.context1.getService(ResourceResolverFactory.class)));
        this.scheduler = new DummyScheduler();
        logger.info("setup: end");
    }

    @After
    public void teardown() throws Exception {
        logger.info("teardown: start");
        if (this.mgr != null) {
            this.mgr.handleDeactivated();
        }
        this.mgr = null;
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        discoveryLogger.setLevel(this.logLevel);
        logger.info("teardown: end");
    }

    void assertEvents(DummyListener listener, TopologyEvent ... events) {
        TestHelper.assertEvents(this.mgr, listener, events);
    }

    @Test
    @Ignore
    public void testRepeativeNewViewCalls() throws Exception {
        Assert.fail((String)"do me");
    }

    @Test
    public void testSyncServiceDelayOnFirstView_noEventDelaying() throws Exception {
        this.doTestSyncServiceDelayOnFirstView(false);
    }

    @Test
    public void testSyncServiceDelayOnFirstView_withEventDelaying() throws Exception {
        this.doTestSyncServiceDelayOnFirstView(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSyncServiceDelayOnFirstView(boolean minEventDelayHandler) throws InterruptedException {
        final DummyListener listener = new DummyListener();
        String slingId1 = UUID.randomUUID().toString();
        String slingId2 = UUID.randomUUID().toString();
        String slingId3 = UUID.randomUUID().toString();
        String clusterId = UUID.randomUUID().toString();
        DummyTopologyView view0 = new DummyTopologyView().addInstance(slingId1, new DefaultClusterView(clusterId), true, true);
        DefaultClusterView cluster = new DefaultClusterView(clusterId);
        final DummyTopologyView view1 = new DummyTopologyView().addInstance(slingId1, cluster, true, true).addInstance(slingId2, cluster, false, false).addInstance(slingId3, cluster, false, false);
        DummyClusterSyncService s1 = new DummyClusterSyncService(3600000L, 10L, "s1");
        DummyClusterSyncService s2 = new DummyClusterSyncService(3600000L, 10L, "s2");
        ClusterSyncServiceChain chain = new ClusterSyncServiceChain(new ClusterSyncService[]{s1, s2});
        try {
            this.mgr = new ViewStateManagerImpl((Lock)new ReentrantLock(), (ClusterSyncService)chain);
            this.mgr.bind((TopologyEventListener)listener);
            if (minEventDelayHandler) {
                this.mgr.installMinEventDelayHandler((DiscoveryService)this, this.scheduler, 1L);
            }
            logger.info("testSyncServiceDelayOnFirstView: start");
            this.mgr.handleActivated();
            s1.setCheckResult(true);
            s2.setCheckResult(true);
            this.view = view0;
            this.mgr.handleNewView((BaseTopologyView)view0);
            Assert.assertTrue((boolean)this.waitForCondition(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return listener.countEvents() == 1;
                }
            }, 5000L));
            logger.info("testSyncServiceDelayOnFirstView: second call to handleNewView");
            s1.setCheckResult(false);
            s2.setCheckResult(false);
            s1.resetCounter();
            s2.resetCounter();
            s1.setCheckSemaphoreSetPermits(2);
            this.view = view1;
            this.mgr.handleNewView((BaseTopologyView)view1);
            Assert.assertTrue((boolean)s1.waitForCheckCounterAtMin(2L, 5000L));
            Assert.assertEquals((long)0L, (long)s2.getCheckCounter());
            Assert.assertTrue((boolean)s1.waitForCheckBlockingAtMin(1, 5000L));
            s1.setCheckResult(true);
            s2.setCheckSemaphoreSetPermits(0);
            s1.setCheckSemaphoreRelease(1);
            Assert.assertTrue((boolean)s2.waitForCheckBlockingAtMin(1, 5000L));
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    TestOakViewStateManager.this.mgr.handleNewView((BaseTopologyView)view1);
                }
            });
            t.start();
            t.join(5000L);
            Assert.assertTrue((boolean)s1.waitForCheckBlockingAtMin(1, 5000L));
            s1.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
            Assert.assertTrue((boolean)s2.waitForCheckBlockingAtMin(2, 5000L));
            s2.setCheckSemaphoreRelease(100);
            Thread.sleep(2000L);
            long s1Blocking = s1.getCheckBlocking();
            long s2Blocking = s2.getCheckBlocking();
            Assert.assertEquals((long)0L, (long)s1Blocking);
            Assert.assertEquals((long)1L, (long)s2Blocking);
        }
        finally {
            s1.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
            s2.setCheckSemaphoreSetPermits(Integer.MAX_VALUE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForCondition(Callable<Boolean> condition, long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("timeoutMillis must be 0 or positive, is: " + timeoutMillis);
        }
        long timeout = System.currentTimeMillis() + timeoutMillis;
        try {
            while (condition.call() == false) {
                long delta = Math.min(10L, timeout - System.currentTimeMillis());
                if (delta <= 0L) {
                    return condition.call();
                }
                try {
                    Thread.sleep(delta);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return condition.call();
        }
        catch (Exception e) {
            throw new AssertionError("Got Exception: " + String.valueOf(e), e);
        }
    }

    public TopologyView getTopology() {
        return this.view;
    }
}

