/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.util.decorators;

import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceException;
import org.ops4j.peaberry.builders.ImportDecorator;
import org.ops4j.peaberry.util.DelegatingImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StickyDecorator<S>
implements ImportDecorator<S> {
    final Callable<Boolean> resetTask;

    public StickyDecorator(Callable<Boolean> resetTask) {
        this.resetTask = resetTask;
    }

    @Override
    public <T extends S> Import<T> decorate(Import<T> service) {
        return new StickyImport<T>(service);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StickyImport<T>
    extends DelegatingImport<T> {
        private WeakReference<T> instanceRef;
        private boolean reset;

        StickyImport(Import<T> service) {
            super(service);
            this.reset = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized T get() {
            if (null != StickyDecorator.this.resetTask && null != this.instanceRef && !super.available()) {
                this.instanceRef.clear();
                this.instanceRef = null;
                try {
                    this.reset = StickyDecorator.this.resetTask.call();
                }
                catch (Exception e) {
                    throw new ServiceException("Exception in resetTask", e);
                }
                if (this.reset) {
                    super.unget();
                }
            }
            if (this.reset) {
                try {
                    Object instance = super.get();
                    this.instanceRef = new WeakReference(instance);
                    this.reset = null == instance;
                }
                finally {
                    if (this.reset) {
                        this.instanceRef = null;
                        super.unget();
                    }
                }
            }
            return null == this.instanceRef ? null : (T)this.instanceRef.get();
        }

        @Override
        public void unget() {
        }
    }
}

