/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionOptions {
    private static Logger log = LoggerFactory.getLogger(ConnectionOptions.class);
    private final boolean isUseSystemPropertes;
    private final int maxConnections;
    private final boolean isAllowSelfSignedCertificates;
    private final boolean isDisableHostnameVerification;
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyProtocol;
    private final String proxyUsername;
    private final String proxyPassword;
    private final int connectionTimeoutMs;
    private final int requestTimeoutMs;
    private final int socketTimeoutMs;
    public static final String PARAM_USE_SYSTEM_PROPERTIES = "org.apache.jackrabbit.spi2dav.connection.useSystemProperties";
    public static final String PARAM_ALLOW_SELF_SIGNED_CERTIFICATES = "org.apache.jackrabbit.spi2dav.connection.allowSelfSignedCertificates";
    public static final String PARAM_DISABLE_HOSTNAME_VERIFICATION = "org.apache.jackrabbit.spi2dav.connection.disableHostnameVerification";
    public static final String PARAM_PROXY_HOST = "org.apache.jackrabbit.spi2dav.connection.proxyHost";
    public static final String PARAM_PROXY_PORT = "org.apache.jackrabbit.spi2dav.connection.proxyPort";
    public static final String PARAM_PROXY_PROTOCOL = "org.apache.jackrabbit.spi2dav.connection.proxyProtocol";
    public static final String PARAM_PROXY_USERNAME = "org.apache.jackrabbit.spi2dav.connection.proxyUsername";
    public static final String PARAM_PROXY_PASSWORD = "org.apache.jackrabbit.spi2dav.connection.proxyPassword";
    public static final String PARAM_CONNECTION_TIMEOUT_MS = "org.apache.jackrabbit.spi2dav.connection.connectionTimeoutMs";
    public static final String PARAM_REQUEST_TIMEOUT_MS = "org.apache.jackrabbit.spi2dav.connection.requestTimeoutMs";
    public static final String PARAM_SOCKET_TIMEOUT_MS = "org.apache.jackrabbit.spi2dav.connection.socketTimeoutMs";
    public static final String PARAM_MAX_CONNECTIONS = "connection.maxConnections";
    public static final int MAX_CONNECTIONS_DEFAULT = 20;
    public static final ConnectionOptions DEFAULT = new Builder().build();

    private ConnectionOptions(boolean isUseSystemPropertes, int maxConnections, boolean isAllowSelfSignedCertificates, boolean isDisableHostnameVerification, int connectionTimeoutMs, int requestTimeoutMs, int socketTimeoutMs, String proxyHost, int proxyPort, String proxyProtocol, String proxyUsername, String proxyPassword) {
        this.isUseSystemPropertes = isUseSystemPropertes;
        this.maxConnections = maxConnections;
        this.isAllowSelfSignedCertificates = isAllowSelfSignedCertificates;
        this.isDisableHostnameVerification = isDisableHostnameVerification;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.socketTimeoutMs = socketTimeoutMs;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyProtocol = proxyProtocol;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public boolean isUseSystemPropertes() {
        return this.isUseSystemPropertes;
    }

    public boolean isAllowSelfSignedCertificates() {
        return this.isAllowSelfSignedCertificates;
    }

    public boolean isDisableHostnameVerification() {
        return this.isDisableHostnameVerification;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyProtocol() {
        return this.proxyProtocol;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.connectionTimeoutMs;
        result = 31 * result + (this.isAllowSelfSignedCertificates ? 1231 : 1237);
        result = 31 * result + (this.isDisableHostnameVerification ? 1231 : 1237);
        result = 31 * result + (this.isUseSystemPropertes ? 1231 : 1237);
        result = 31 * result + this.maxConnections;
        result = 31 * result + (this.proxyHost == null ? 0 : this.proxyHost.hashCode());
        result = 31 * result + (this.proxyPassword == null ? 0 : this.proxyPassword.hashCode());
        result = 31 * result + this.proxyPort;
        result = 31 * result + (this.proxyProtocol == null ? 0 : this.proxyProtocol.hashCode());
        result = 31 * result + (this.proxyUsername == null ? 0 : this.proxyUsername.hashCode());
        result = 31 * result + this.requestTimeoutMs;
        result = 31 * result + this.socketTimeoutMs;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionOptions other = (ConnectionOptions)obj;
        if (this.connectionTimeoutMs != other.connectionTimeoutMs) {
            return false;
        }
        if (this.isAllowSelfSignedCertificates != other.isAllowSelfSignedCertificates) {
            return false;
        }
        if (this.isDisableHostnameVerification != other.isDisableHostnameVerification) {
            return false;
        }
        if (this.isUseSystemPropertes != other.isUseSystemPropertes) {
            return false;
        }
        if (this.maxConnections != other.maxConnections) {
            return false;
        }
        if (this.proxyHost == null ? other.proxyHost != null : !this.proxyHost.equals(other.proxyHost)) {
            return false;
        }
        if (this.proxyPassword == null ? other.proxyPassword != null : !this.proxyPassword.equals(other.proxyPassword)) {
            return false;
        }
        if (this.proxyPort != other.proxyPort) {
            return false;
        }
        if (this.proxyProtocol == null ? other.proxyProtocol != null : !this.proxyProtocol.equals(other.proxyProtocol)) {
            return false;
        }
        if (this.proxyUsername == null ? other.proxyUsername != null : !this.proxyUsername.equals(other.proxyUsername)) {
            return false;
        }
        if (this.requestTimeoutMs != other.requestTimeoutMs) {
            return false;
        }
        return this.socketTimeoutMs == other.socketTimeoutMs;
    }

    public String toString() {
        return "ConnectionOptions [isUseSystemPropertes=" + this.isUseSystemPropertes + ", maxConnections=" + this.maxConnections + ", isAllowSelfSignedCertificates=" + this.isAllowSelfSignedCertificates + ", isDisableHostnameVerification=" + this.isDisableHostnameVerification + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyProtocol=" + this.proxyProtocol + ", proxyUsername=" + this.proxyUsername + ", proxyPassword=" + this.proxyPassword + ", connectionTimeoutMs=" + this.connectionTimeoutMs + ", requestTimeoutMs=" + this.requestTimeoutMs + ", socketTimeoutMs=" + this.socketTimeoutMs + "]";
    }

    public Map<String, String> toServiceFactoryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.isUseSystemPropertes) {
            parameters.put(PARAM_USE_SYSTEM_PROPERTIES, Boolean.toString(this.isUseSystemPropertes));
        }
        if (this.maxConnections != 20) {
            parameters.put(PARAM_MAX_CONNECTIONS, Integer.toString(this.maxConnections));
        }
        if (this.isAllowSelfSignedCertificates) {
            parameters.put(PARAM_ALLOW_SELF_SIGNED_CERTIFICATES, Boolean.toString(this.isAllowSelfSignedCertificates));
        }
        if (this.isDisableHostnameVerification) {
            parameters.put(PARAM_DISABLE_HOSTNAME_VERIFICATION, Boolean.toString(this.isDisableHostnameVerification));
        }
        if (this.connectionTimeoutMs != -1) {
            parameters.put(PARAM_CONNECTION_TIMEOUT_MS, Integer.toString(this.connectionTimeoutMs));
        }
        if (this.requestTimeoutMs != -1) {
            parameters.put(PARAM_REQUEST_TIMEOUT_MS, Integer.toString(this.requestTimeoutMs));
        }
        if (this.socketTimeoutMs != -1) {
            parameters.put(PARAM_SOCKET_TIMEOUT_MS, Integer.toString(this.socketTimeoutMs));
        }
        if (this.proxyHost != null) {
            parameters.put(PARAM_PROXY_HOST, this.proxyHost);
        }
        if (this.proxyPort != -1) {
            parameters.put(PARAM_PROXY_PORT, Integer.toString(this.proxyPort));
        }
        if (this.proxyProtocol != null) {
            parameters.put(PARAM_PROXY_PROTOCOL, this.proxyProtocol);
        }
        if (this.proxyUsername != null) {
            parameters.put(PARAM_PROXY_USERNAME, this.proxyUsername);
        }
        if (this.proxyPassword != null) {
            parameters.put(PARAM_PROXY_PASSWORD, this.proxyPassword);
        }
        return parameters;
    }

    public static ConnectionOptions fromServiceFactoryParameters(Map<?, ?> parameters) {
        return new ConnectionOptions(ConnectionOptions.getBooleanValueFromParameter(parameters, false, PARAM_USE_SYSTEM_PROPERTIES), ConnectionOptions.getIntegerValueFromParameter(parameters, 20, PARAM_MAX_CONNECTIONS, "org.apache.jackrabbit.spi2dav.MaxConnections", "org.apache.jackrabbit.spi2davex.MaxConnections"), ConnectionOptions.getBooleanValueFromParameter(parameters, false, PARAM_ALLOW_SELF_SIGNED_CERTIFICATES), ConnectionOptions.getBooleanValueFromParameter(parameters, false, PARAM_DISABLE_HOSTNAME_VERIFICATION), ConnectionOptions.getIntegerValueFromParameter(parameters, -1, PARAM_CONNECTION_TIMEOUT_MS), ConnectionOptions.getIntegerValueFromParameter(parameters, -1, PARAM_REQUEST_TIMEOUT_MS), ConnectionOptions.getIntegerValueFromParameter(parameters, -1, PARAM_SOCKET_TIMEOUT_MS), ConnectionOptions.getStringValueFromParameter(parameters, null, PARAM_PROXY_HOST), ConnectionOptions.getIntegerValueFromParameter(parameters, -1, PARAM_PROXY_PORT), ConnectionOptions.getStringValueFromParameter(parameters, null, PARAM_PROXY_PROTOCOL), ConnectionOptions.getStringValueFromParameter(parameters, null, PARAM_PROXY_USERNAME), ConnectionOptions.getStringValueFromParameter(parameters, null, PARAM_PROXY_PASSWORD));
    }

    private static int getIntegerValueFromParameter(Map<?, ?> parameters, int defaultValue, String ... parameterKeys) {
        for (String key : parameterKeys) {
            Object value = parameters.get(key);
            if (value == null) continue;
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                log.warn("Invalid integer value '{}' given for parameter '{}'. Using default '{}' instead.", new Object[]{value, key, defaultValue});
            }
        }
        return defaultValue;
    }

    private static boolean getBooleanValueFromParameter(Map<?, ?> parameters, boolean defaultValue, String ... parameterKeys) {
        for (String key : parameterKeys) {
            Object value = parameters.get(key);
            if (value == null) continue;
            return Boolean.parseBoolean(value.toString());
        }
        return defaultValue;
    }

    private static String getStringValueFromParameter(Map<?, ?> parameters, String defaultValue, String ... parameterKeys) {
        for (String key : parameterKeys) {
            Object value = parameters.get(key);
            if (value == null) continue;
            return value.toString();
        }
        return defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean isUseSystemPropertes;
        private int maxConnections = 20;
        private boolean isAllowSelfSignedCertificates;
        private boolean isDisableHostnameVerification;
        private String proxyHost;
        private int proxyPort = -1;
        private String proxyProtocol;
        private String proxyUsername;
        private String proxyPassword;
        private int connectionTimeoutMs = -1;
        private int requestTimeoutMs = -1;
        private int socketTimeoutMs = -1;

        public Builder useSystemProperties(boolean isUseSystemPropertes) {
            this.isUseSystemPropertes = isUseSystemPropertes;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder allowSelfSignedCertificates(boolean isAllowSelfSignedCertificates) {
            this.isAllowSelfSignedCertificates = isAllowSelfSignedCertificates;
            return this;
        }

        public Builder disableHostnameVerification(boolean isDisableHostnameVerification) {
            this.isDisableHostnameVerification = isDisableHostnameVerification;
            return this;
        }

        public Builder connectionTimeoutMs(int connectionTimeoutMs) {
            this.connectionTimeoutMs = connectionTimeoutMs;
            return this;
        }

        public Builder requestTimeoutMs(int requestTimeoutMs) {
            this.requestTimeoutMs = requestTimeoutMs;
            return this;
        }

        public Builder socketTimeoutMs(int socketTimeoutMs) {
            this.socketTimeoutMs = socketTimeoutMs;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder proxyProtocol(String proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
            return this;
        }

        public Builder proxyUsername(String proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public ConnectionOptions build() {
            return new ConnectionOptions(this.isUseSystemPropertes, this.maxConnections, this.isAllowSelfSignedCertificates, this.isDisableHostnameVerification, this.connectionTimeoutMs, this.requestTimeoutMs, this.socketTimeoutMs, this.proxyHost, this.proxyPort, this.proxyProtocol, this.proxyUsername, this.proxyPassword);
        }
    }
}

