/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.internal.validation;

import org.apache.sling.ide.eclipse.internal.validation.AbstractValidator;
import org.apache.sling.ide.eclipse.internal.validation.ServiceComponentHeaderValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;

public class BundleProjectValidator
extends AbstractValidator {
    private final ServiceComponentHeaderValidator scValidator = new ServiceComponentHeaderValidator();

    public ValidationResult validate(ValidationEvent event, ValidationState state, IProgressMonitor monitor) {
        ValidationResult res = new ValidationResult();
        IResource resource = event.getResource();
        if (!resource.getName().equals("MANIFEST.MF") || resource.getType() != 1) {
            return res;
        }
        try {
            if (!resource.isSynchronized(0)) {
                resource.refreshLocal(0, null);
            }
            for (IFile descriptor : this.scValidator.findMissingScrDescriptors((IFile)resource)) {
                this.addValidatorMessage(res, resource, "No DS descriptor found at path " + String.valueOf(descriptor.getProjectRelativePath()) + ".");
            }
        }
        catch (CoreException e) {
            this.getLogger().warn("Failed validating project " + String.valueOf(resource.getFullPath()), (Throwable)e);
        }
        return res;
    }
}

