/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.types.date;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;
import net.sf.jasperreports.types.date.DateRange;

public abstract class DateRangeBaseSQLEqualityClause
implements JRClauseFunction {
    public static final String EXCEPTION_MESSAGE_KEY_EQUAL_CLAUSE_DB_COLUMN_TOKEN_MISSING = "date.range.equal.clause.db.column.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_EQUAL_CLAUSE_PARAMETER_TOKEN_MISSING = "date.range.equal.clause.parameter.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_PARAMETER_TYPE = "date.range.unexpected.parameter.type";

    protected DateRangeBaseSQLEqualityClause() {
    }

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String clauseId = clauseTokens.getClauseId();
        String col = clauseTokens.getToken(1);
        String param = clauseTokens.getToken(2);
        if (col == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EQUAL_CLAUSE_DB_COLUMN_TOKEN_MISSING, (Object[])null);
        }
        if (param == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EQUAL_CLAUSE_PARAMETER_TOKEN_MISSING, (Object[])null);
        }
        Object paramValue = queryContext.getValueParameter(param).getValue();
        if (paramValue != null && !(paramValue instanceof DateRange)) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_PARAMETER_TYPE, param, clauseId);
        }
        DateRange dateRange = (DateRange)paramValue;
        StringBuffer queryBuffer = queryContext.queryBuffer();
        queryBuffer.append('(');
        this.applyDateRange(queryContext, col, dateRange);
        queryBuffer.append(')');
    }

    protected abstract void applyDateRange(JRQueryClauseContext var1, String var2, DateRange var3);
}

