/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import com.yubico.webauthn.data.PublicKeyCredentialType;
import lombok.Generated;
import lombok.NonNull;

public final class PublicKeyCredentialParameters {
    @NonNull
    private final COSEAlgorithmIdentifier alg;
    @NonNull
    private final PublicKeyCredentialType type;
    public static final PublicKeyCredentialParameters EdDSA = PublicKeyCredentialParameters.builder().alg(COSEAlgorithmIdentifier.EdDSA).build();
    public static final PublicKeyCredentialParameters ES256 = PublicKeyCredentialParameters.builder().alg(COSEAlgorithmIdentifier.ES256).build();
    public static final PublicKeyCredentialParameters RS1 = PublicKeyCredentialParameters.builder().alg(COSEAlgorithmIdentifier.RS1).build();
    public static final PublicKeyCredentialParameters RS256 = PublicKeyCredentialParameters.builder().alg(COSEAlgorithmIdentifier.RS256).build();

    private PublicKeyCredentialParameters(@JsonProperty(value="alg") @NonNull COSEAlgorithmIdentifier alg, @JsonProperty(value="type") @NonNull PublicKeyCredentialType type) {
        if (alg == null) {
            throw new NullPointerException("alg is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.alg = alg;
        this.type = type;
    }

    public static PublicKeyCredentialParametersBuilder.MandatoryStages builder() {
        return new PublicKeyCredentialParametersBuilder.MandatoryStages();
    }

    @Generated
    private static PublicKeyCredentialType $default$type() {
        return PublicKeyCredentialType.PUBLIC_KEY;
    }

    @Generated
    public PublicKeyCredentialParametersBuilder toBuilder() {
        return new PublicKeyCredentialParametersBuilder().alg(this.alg).type(this.type);
    }

    @NonNull
    @Generated
    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    @NonNull
    @Generated
    public PublicKeyCredentialType getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicKeyCredentialParameters)) {
            return false;
        }
        PublicKeyCredentialParameters other = (PublicKeyCredentialParameters)o;
        COSEAlgorithmIdentifier this$alg = this.getAlg();
        COSEAlgorithmIdentifier other$alg = other.getAlg();
        if (this$alg == null ? other$alg != null : !((Object)((Object)this$alg)).equals((Object)other$alg)) {
            return false;
        }
        PublicKeyCredentialType this$type = this.getType();
        PublicKeyCredentialType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        COSEAlgorithmIdentifier $alg = this.getAlg();
        result = result * 59 + ($alg == null ? 43 : ((Object)((Object)$alg)).hashCode());
        PublicKeyCredentialType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PublicKeyCredentialParameters(alg=" + (Object)((Object)this.getAlg()) + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public static class PublicKeyCredentialParametersBuilder {
        @Generated
        private COSEAlgorithmIdentifier alg;
        @Generated
        private boolean type$set;
        @Generated
        private PublicKeyCredentialType type$value;

        @Generated
        PublicKeyCredentialParametersBuilder() {
        }

        @Generated
        public PublicKeyCredentialParametersBuilder alg(@NonNull COSEAlgorithmIdentifier alg) {
            if (alg == null) {
                throw new NullPointerException("alg is marked non-null but is null");
            }
            this.alg = alg;
            return this;
        }

        @Generated
        public PublicKeyCredentialParametersBuilder type(@NonNull PublicKeyCredentialType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public PublicKeyCredentialParameters build() {
            PublicKeyCredentialType type$value = this.type$value;
            if (!this.type$set) {
                type$value = PublicKeyCredentialParameters.$default$type();
            }
            return new PublicKeyCredentialParameters(this.alg, type$value);
        }

        @Generated
        public String toString() {
            return "PublicKeyCredentialParameters.PublicKeyCredentialParametersBuilder(alg=" + (Object)((Object)this.alg) + ", type$value=" + (Object)((Object)this.type$value) + ")";
        }

        public static class MandatoryStages {
            private PublicKeyCredentialParametersBuilder builder = new PublicKeyCredentialParametersBuilder();

            public PublicKeyCredentialParametersBuilder alg(COSEAlgorithmIdentifier alg) {
                return this.builder.alg(alg);
            }
        }
    }
}

