/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.claims.mapping;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.mapping.OidcAttributeToScopeClaimMapper;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceChainingAttributeReleasePolicy;

public class OidcDefaultAttributeToScopeClaimMapper
implements OidcAttributeToScopeClaimMapper {
    private final Map<String, String> claimsToAttribute;

    @Override
    public String getMappedAttribute(String claim, RegisteredService registeredService) {
        Map<String, String> container = OidcDefaultAttributeToScopeClaimMapper.getClaimMappingsContainer(registeredService);
        return Optional.ofNullable(container.get(claim)).orElseGet(() -> this.claimsToAttribute.get(claim));
    }

    @Override
    public boolean containsMappedAttribute(String claim, RegisteredService registeredService) {
        Map<String, String> container = OidcDefaultAttributeToScopeClaimMapper.getClaimMappingsContainer(registeredService);
        return this.claimsToAttribute.containsKey(claim) || container.containsKey(claim);
    }

    private static Map<String, String> getClaimMappingsContainer(RegisteredService registeredService) {
        Stream<Object> finalMap = Stream.empty();
        if (registeredService.getAttributeReleasePolicy() instanceof RegisteredServiceChainingAttributeReleasePolicy) {
            RegisteredServiceChainingAttributeReleasePolicy chain = (RegisteredServiceChainingAttributeReleasePolicy)registeredService.getAttributeReleasePolicy();
            for (RegisteredServiceAttributeReleasePolicy policy : chain.getPolicies()) {
                Stream<Map.Entry<String, String>> result = OidcDefaultAttributeToScopeClaimMapper.getClaimMappingsForPolicy(policy);
                finalMap = Stream.concat(finalMap, result);
            }
        }
        Stream<Map.Entry<String, String>> result = OidcDefaultAttributeToScopeClaimMapper.getClaimMappingsForPolicy(registeredService.getAttributeReleasePolicy());
        Stream<Map.Entry<String, String>> finalResult = Stream.concat(finalMap, result);
        return finalResult.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Stream<Map.Entry<String, String>> getClaimMappingsForPolicy(RegisteredServiceAttributeReleasePolicy policy) {
        return policy instanceof OidcRegisteredServiceAttributeReleasePolicy ? ((OidcRegisteredServiceAttributeReleasePolicy)policy).getClaimMappings().entrySet().stream() : Stream.empty();
    }

    @Generated
    public OidcDefaultAttributeToScopeClaimMapper(Map<String, String> claimsToAttribute) {
        this.claimsToAttribute = claimsToAttribute;
    }
}

