/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.AbstractResult;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UnsupportedException;

class MappedQueryResultObjectProvider
implements ResultObjectProvider {
    private final QueryResultMapping _map;
    private final JDBCStore _store;
    private final JDBCFetchConfiguration _fetch;
    private final MappingResult _mres;

    public MappedQueryResultObjectProvider(QueryResultMapping map, JDBCStore store, JDBCFetchConfiguration fetch, Result res) {
        this._map = map;
        this._store = store;
        this._fetch = fetch == null ? store.getFetchConfiguration() : fetch;
        this._mres = new MappingResult(res);
    }

    public boolean supportsRandomAccess() {
        try {
            return this._mres.supportsRandomAccess();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void open() {
    }

    public Object getResultObject() throws SQLException {
        int i;
        QueryResultMapping.PCResult[] pcs = this._map.getPCResults();
        Object[] cols = this._map.getColumnResults();
        if (pcs.length == 0 && cols.length == 1) {
            return this._mres.getObject(cols[0], 1012, null);
        }
        if (pcs.length == 1 && cols.length == 0) {
            return this._mres.load(pcs[0], this._store, this._fetch);
        }
        Object[] ret = new Object[pcs.length + cols.length];
        for (i = 0; i < pcs.length; ++i) {
            ret[i] = this._mres.load(pcs[i], this._store, this._fetch);
        }
        for (i = 0; i < cols.length; ++i) {
            ret[pcs.length + i] = this._mres.getObject(cols[i], 1012, null);
        }
        return ret;
    }

    public boolean next() throws SQLException {
        return this._mres.next();
    }

    public boolean absolute(int pos) throws SQLException {
        return this._mres.absolute(pos);
    }

    public int size() throws SQLException {
        if (this._fetch.getLRSSize() == 0 || !this.supportsRandomAccess()) {
            return Integer.MAX_VALUE;
        }
        return this._mres.size();
    }

    public void reset() {
        throw new UnsupportedException();
    }

    public void close() {
        this._mres.close();
    }

    public void handleCheckedException(Exception e) {
        if (e instanceof SQLException) {
            throw SQLExceptions.getStore((SQLException)e, this._store.getDBDictionary());
        }
        throw new StoreException((Throwable)e);
    }

    private static class MappingResult
    extends AbstractResult {
        private final Result _res;
        private final Stack _requests = new Stack();
        private QueryResultMapping.PCResult _pc = null;

        public MappingResult(Result res) {
            this._res = res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object load(QueryResultMapping.PCResult pc, JDBCStore store, JDBCFetchConfiguration fetch) throws SQLException {
            this._pc = pc;
            try {
                Object object = this.load(pc.getCandidateTypeMapping(), store, fetch);
                return object;
            }
            finally {
                this._pc = null;
            }
        }

        @Override
        public Object load(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch) throws SQLException {
            return this.load(mapping, store, fetch, null);
        }

        @Override
        public Object load(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch, Joins joins) throws SQLException {
            if (this._pc == null) {
                return super.load(mapping, store, fetch, joins);
            }
            return ((JDBCStoreManager)store).load(mapping, fetch, this._pc.getExcludes(this._requests), (Result)this);
        }

        @Override
        public Object getEager(FieldMapping key) {
            Object ret = this._res.getEager(key);
            if (this._pc == null || ret != null) {
                return ret;
            }
            return this._pc.hasEager(this._requests, key) ? this : null;
        }

        @Override
        public void putEager(FieldMapping key, Object res) {
            this._res.putEager(key, res);
        }

        @Override
        public void close() {
            this._res.close();
        }

        @Override
        public Joins newJoins() {
            return this._res.newJoins();
        }

        @Override
        public boolean supportsRandomAccess() throws SQLException {
            return this._res.supportsRandomAccess();
        }

        @Override
        public ClassMapping getBaseMapping() {
            return this._res.getBaseMapping();
        }

        @Override
        public int size() throws SQLException {
            return this._res.size();
        }

        @Override
        public void startDataRequest(Object mapping) {
            this._requests.push(mapping);
        }

        @Override
        public void endDataRequest() {
            this._requests.pop();
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this._res.wasNull();
        }

        @Override
        protected Object translate(Object obj, Joins joins) {
            return this._pc == null ? obj : this._pc.map(this._requests, obj, joins);
        }

        @Override
        protected boolean absoluteInternal(int row) throws SQLException {
            return this._res.absolute(row);
        }

        @Override
        protected boolean nextInternal() throws SQLException {
            return this._res.next();
        }

        @Override
        protected boolean containsInternal(Object obj, Joins joins) throws SQLException {
            return this._res.contains(this.translate(obj, joins));
        }

        @Override
        protected Array getArrayInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getArray((Column)obj, joins);
            }
            return this._res.getArray(obj);
        }

        @Override
        protected InputStream getAsciiStreamInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getAsciiStream((Column)obj, joins);
            }
            return this._res.getAsciiStream(obj);
        }

        @Override
        protected BigDecimal getBigDecimalInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getBigDecimal((Column)obj, joins);
            }
            return this._res.getBigDecimal(obj);
        }

        @Override
        protected Number getNumberInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getNumber((Column)obj, joins);
            }
            return this._res.getNumber(obj);
        }

        @Override
        protected BigInteger getBigIntegerInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getBigInteger((Column)obj, joins);
            }
            return this._res.getBigInteger(obj);
        }

        @Override
        protected InputStream getBinaryStreamInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getBinaryStream((Column)obj, joins);
            }
            return this._res.getBinaryStream(obj);
        }

        @Override
        protected Blob getBlobInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getBlob((Column)obj, joins);
            }
            return this._res.getBlob(obj);
        }

        @Override
        protected boolean getBooleanInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getBoolean((Column)obj, joins);
            }
            return this._res.getBoolean(obj);
        }

        @Override
        protected byte getByteInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getByte((Column)obj, joins);
            }
            return this._res.getByte(obj);
        }

        @Override
        protected byte[] getBytesInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getBytes((Column)obj, joins);
            }
            return this._res.getBytes(obj);
        }

        @Override
        protected Calendar getCalendarInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getCalendar((Column)obj, joins);
            }
            return this._res.getCalendar(obj);
        }

        @Override
        protected char getCharInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getChar((Column)obj, joins);
            }
            return this._res.getChar(obj);
        }

        @Override
        protected Reader getCharacterStreamInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getCharacterStream((Column)obj, joins);
            }
            return this._res.getCharacterStream(obj);
        }

        @Override
        protected Clob getClobInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getClob((Column)obj, joins);
            }
            return this._res.getClob(obj);
        }

        @Override
        protected java.util.Date getDateInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getDate((Column)obj, joins);
            }
            return this._res.getDate(obj);
        }

        @Override
        protected Date getDateInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getDate((Column)obj, cal, joins);
            }
            return this._res.getDate(obj, cal);
        }

        @Override
        protected double getDoubleInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getDouble((Column)obj, joins);
            }
            return this._res.getDouble(obj);
        }

        @Override
        protected float getFloatInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getFloat((Column)obj, joins);
            }
            return this._res.getFloat(obj);
        }

        @Override
        protected int getIntInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getInt((Column)obj, joins);
            }
            return this._res.getInt(obj);
        }

        @Override
        protected Locale getLocaleInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getLocale((Column)obj, joins);
            }
            return this._res.getLocale(obj);
        }

        @Override
        protected long getLongInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getLong((Column)obj, joins);
            }
            return this._res.getLong(obj);
        }

        @Override
        public Object getObject(Column col, Object arg, Joins joins) throws SQLException {
            return this.getObjectInternal(this.translate(col, joins), col.getJavaType(), arg, joins);
        }

        @Override
        protected Object getObjectInternal(Object obj, int metaTypeCode, Object arg, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                Column col = (Column)obj;
                Object resultCol = this._pc.getMapping(col.toString());
                if (resultCol != null) {
                    int javaType = col.getJavaType();
                    col = new Column(DBIdentifier.newColumn(resultCol.toString()), col.getTable());
                    col.setJavaType(javaType);
                }
                return this._res.getObject(col, arg, joins);
            }
            return this._res.getObject(obj, metaTypeCode, arg);
        }

        @Override
        protected Object getSQLObjectInternal(Object obj, Map map, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getSQLObject((Column)obj, map, joins);
            }
            return this._res.getSQLObject(obj, map);
        }

        @Override
        protected Object getStreamInternal(JDBCStore store, Object obj, int metaTypeCode, Object arg, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getObject((Column)obj, arg, joins);
            }
            return this._res.getObject(obj, metaTypeCode, arg);
        }

        @Override
        protected Ref getRefInternal(Object obj, Map map, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getRef((Column)obj, map, joins);
            }
            return this._res.getRef(obj, map);
        }

        @Override
        protected short getShortInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getShort((Column)obj, joins);
            }
            return this._res.getShort(obj);
        }

        protected String getStringInternal(Object obj, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getString((Column)obj, joins);
            }
            return this._res.getString(obj);
        }

        @Override
        protected Time getTimeInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getTime((Column)obj, cal, joins);
            }
            return this._res.getTime(obj, cal);
        }

        @Override
        protected Timestamp getTimestampInternal(Object obj, Calendar cal, Joins joins) throws SQLException {
            if (obj instanceof Column) {
                return this._res.getTimestamp((Column)obj, cal, joins);
            }
            return this._res.getTimestamp(obj, cal);
        }
    }
}

