/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.views.OAuth20DefaultUserProfileViewRenderer;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;

public class OidcUserProfileViewRenderer
extends OAuth20DefaultUserProfileViewRenderer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcUserProfileViewRenderer.class);
    private final OAuth20TokenSigningAndEncryptionService signingAndEncryptionService;

    public OidcUserProfileViewRenderer(OAuthProperties oauthProperties, ServicesManager servicesManager, OAuth20TokenSigningAndEncryptionService signingAndEncryptionService) {
        super(servicesManager, oauthProperties);
        this.signingAndEncryptionService = signingAndEncryptionService;
    }

    protected ResponseEntity renderProfileForModel(Map<String, Object> userProfile, OAuth20AccessToken accessToken, HttpServletResponse response) {
        OAuthRegisteredService service = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)accessToken.getClientId());
        if (!(service instanceof OidcRegisteredService)) {
            return super.renderProfileForModel(userProfile, accessToken, response);
        }
        return (ResponseEntity)FunctionUtils.doAndHandle(() -> {
            OidcRegisteredService registeredService = (OidcRegisteredService)service;
            if (this.signingAndEncryptionService.shouldSignToken((OAuthRegisteredService)registeredService) || this.signingAndEncryptionService.shouldEncryptToken((OAuthRegisteredService)registeredService)) {
                return this.signAndEncryptUserProfileClaims(userProfile, response, registeredService);
            }
            return this.buildPlainUserProfileClaims(userProfile, response, registeredService);
        }, e -> ResponseEntity.badRequest().body((Object)"Unable to produce user profile claims")).get();
    }

    protected ResponseEntity<String> buildPlainUserProfileClaims(Map<String, Object> userProfile, HttpServletResponse response, OidcRegisteredService registeredService) {
        response.setContentType("application/json");
        JwtClaims claims = this.convertUserProfileIntoClaims(userProfile);
        return OidcUserProfileViewRenderer.buildResponseEntity(claims.toJson(), response, registeredService);
    }

    private JwtClaims convertUserProfileIntoClaims(Map<String, Object> userProfile) {
        JwtClaims claims = new JwtClaims();
        userProfile.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(CentralAuthenticationService.NAMESPACE)).forEach(entry -> {
            if ("attributes".equals(entry.getKey())) {
                Map attributes = (Map)entry.getValue();
                HashMap newAttributes = new HashMap();
                attributes.forEach((attrName, attrValue) -> newAttributes.put(attrName, this.determineAttributeValue((String)attrName, attrValue)));
                claims.setClaim((String)entry.getKey(), newAttributes);
            } else {
                claims.setClaim((String)entry.getKey(), this.determineAttributeValue((String)entry.getKey(), entry.getValue()));
            }
        });
        return claims;
    }

    protected ResponseEntity<String> signAndEncryptUserProfileClaims(Map<String, Object> userProfile, HttpServletResponse response, OidcRegisteredService registeredService) {
        JwtClaims claims = this.convertUserProfileIntoClaims(userProfile);
        claims.setAudience(registeredService.getClientId());
        claims.setIssuedAt(NumericDate.now());
        claims.setJwtId(UUID.randomUUID().toString());
        claims.setIssuer(this.signingAndEncryptionService.resolveIssuer(Optional.of(registeredService)));
        LOGGER.debug("Collected user profile claims, before cipher operations, are [{}]", (Object)claims);
        String result = this.signingAndEncryptionService.encode((OAuthRegisteredService)registeredService, claims);
        LOGGER.debug("Finalized user profile is [{}]", (Object)result);
        response.setContentType("application/jwt");
        return OidcUserProfileViewRenderer.buildResponseEntity(result, response, registeredService);
    }

    private static ResponseEntity<String> buildResponseEntity(String result, HttpServletResponse response, OidcRegisteredService registeredService) {
        Map<String, String> context = Map.of("Client ID", registeredService.getClientId(), "Service", registeredService.getName(), "Content Type", response.getContentType());
        LoggingUtils.protocolMessage((String)"OpenID Connect User Profile Response", context, (Object)result);
        HttpHeaders headers = new HttpHeaders();
        headers.put("Content-Type", CollectionUtils.wrapList((Object[])new String[]{response.getContentType()}));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)result);
    }

    protected Object determineAttributeValue(String name, Object attrValue) {
        ArrayList value = (ArrayList)CollectionUtils.toCollection((Object)attrValue, ArrayList.class);
        return value.size() == 1 ? value.iterator().next() : value;
    }
}

