/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAdminApiService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RestControllerEndpoint(id="duoAdmin", enableByDefault=false)
public class DuoSecurityAdminApiEndpoint
extends BaseCasActuatorEndpoint {
    private final ApplicationContext applicationContext;

    public DuoSecurityAdminApiEndpoint(CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        super(casProperties);
        this.applicationContext = applicationContext;
    }

    @GetMapping(path={"/{username}"}, produces={"application/json"})
    @Operation(summary="Fetch Duo Security user account from Duo Admin API", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH), @Parameter(name="providerId")})
    public Map<String, DuoSecurityUserAccount> getUser(@PathVariable(value="username") String username, @RequestParam(required=false) String providerId) {
        LinkedHashMap<String, DuoSecurityUserAccount> results = new LinkedHashMap<String, DuoSecurityUserAccount>();
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        providers.stream().filter(Objects::nonNull).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).filter(provider -> StringUtils.isBlank((CharSequence)providerId) || provider.matches(providerId)).filter(provider -> provider.getDuoAuthenticationService().getAdminApiService().isPresent()).forEach(Unchecked.consumer(p -> {
            DuoSecurityAdminApiService duoService = (DuoSecurityAdminApiService)p.getDuoAuthenticationService().getAdminApiService().get();
            duoService.getDuoSecurityUserAccount(username).ifPresent(user -> results.put(p.getId(), (DuoSecurityUserAccount)user));
        }));
        return results;
    }

    @Operation(summary="Create bypass codes using Duo Admin API", parameters={@Parameter(name="username", required=true), @Parameter(name="providerId"), @Parameter(name="userId")})
    @PostMapping(path={"/bypassCodes"}, consumes={"application/json"}, produces={"application/json"})
    public Map<String, List<Long>> createBypassCodes(@RequestParam(value="username", required=false) String username, @RequestParam(value="providerId", required=false) String providerId, @RequestParam(value="userId", required=false) String userId) {
        LinkedHashMap<String, List<Long>> results = new LinkedHashMap<String, List<Long>>();
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        providers.stream().filter(Objects::nonNull).map(DuoSecurityMultifactorAuthenticationProvider.class::cast).filter(provider -> StringUtils.isBlank((CharSequence)providerId) || provider.matches(providerId)).filter(provider -> provider.getDuoAuthenticationService().getAdminApiService().isPresent()).forEach(Unchecked.consumer(p -> {
            String uid;
            DuoSecurityAdminApiService duoService = (DuoSecurityAdminApiService)p.getDuoAuthenticationService().getAdminApiService().get();
            String string = uid = StringUtils.isBlank((CharSequence)userId) ? duoService.getDuoSecurityUserAccount(username).map(DuoSecurityUserAccount::getUserId).orElse("") : userId;
            if (StringUtils.isNotBlank((CharSequence)uid)) {
                List codes = duoService.createDuoSecurityBypassCodesFor(uid);
                results.put(p.getId(), codes);
            }
        }));
        return results;
    }
}

