/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedHashSet;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.model.InboundChannelModelBuilder;
import org.flowable.eventregistry.json.converter.ChannelJsonConverter;
import org.flowable.eventregistry.model.ChannelEventKeyDetection;
import org.flowable.eventregistry.model.ChannelEventTenantIdDetection;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.DelegateExpressionInboundChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.model.JmsInboundChannelModel;
import org.flowable.eventregistry.model.KafkaInboundChannelModel;
import org.flowable.eventregistry.model.RabbitInboundChannelModel;
import org.w3c.dom.Document;

public class InboundChannelDefinitionBuilderImpl
implements InboundChannelModelBuilder {
    protected EventRepositoryService eventRepository;
    protected ChannelJsonConverter channelJsonConverter;
    protected InboundChannelModel channelModel;
    protected String deploymentName;
    protected String resourceName;
    protected String category;
    protected String parentDeploymentId;
    protected String deploymentTenantId;
    protected String key;
    protected InboundChannelModelBuilder.InboundEventProcessingPipelineBuilder inboundEventProcessingPipelineBuilder;

    public InboundChannelDefinitionBuilderImpl(EventRepositoryService eventRepository, ChannelJsonConverter channelJsonConverter) {
        this.eventRepository = eventRepository;
        this.channelJsonConverter = channelJsonConverter;
    }

    public InboundChannelModelBuilder key(String key) {
        this.key = key;
        return this;
    }

    public InboundChannelModelBuilder deploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public InboundChannelModelBuilder resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public InboundChannelModelBuilder category(String category) {
        this.category = category;
        return this;
    }

    public InboundChannelModelBuilder parentDeploymentId(String parentDeploymentId) {
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public InboundChannelModelBuilder deploymentTenantId(String deploymentTenantId) {
        this.deploymentTenantId = deploymentTenantId;
        return this;
    }

    public InboundChannelModelBuilder.InboundEventProcessingPipelineBuilder channelAdapter(String delegateExpression) {
        DelegateExpressionInboundChannelModel channelModel = new DelegateExpressionInboundChannelModel();
        channelModel.setAdapterDelegateExpression(delegateExpression);
        this.channelModel = channelModel;
        this.inboundEventProcessingPipelineBuilder = new InboundEventProcessingPipelineBuilderImpl((InboundChannelModel)channelModel, this.eventRepository, this);
        return this.inboundEventProcessingPipelineBuilder;
    }

    public InboundChannelModelBuilder.InboundJmsChannelBuilder jmsChannelAdapter(String destinationName) {
        JmsInboundChannelModel channelModel = new JmsInboundChannelModel();
        channelModel.setDestination(destinationName);
        this.channelModel = channelModel;
        this.channelModel.setKey(this.key);
        return new InboundJmsChannelBuilderImpl(channelModel, this.eventRepository, this);
    }

    public InboundChannelModelBuilder.InboundRabbitChannelBuilder rabbitChannelAdapter(String queueName) {
        RabbitInboundChannelModel channelModel = new RabbitInboundChannelModel();
        LinkedHashSet<String> queues = new LinkedHashSet<String>();
        queues.add(queueName);
        channelModel.setQueues(queues);
        this.channelModel = channelModel;
        this.channelModel.setKey(this.key);
        return new InboundRabbitChannelBuilderImpl(channelModel, this.eventRepository, this);
    }

    public InboundChannelModelBuilder.InboundKafkaChannelBuilder kafkaChannelAdapter(String topic) {
        KafkaInboundChannelModel channelModel = new KafkaInboundChannelModel();
        LinkedHashSet<String> topics = new LinkedHashSet<String>();
        topics.add(topic);
        channelModel.setTopics(topics);
        this.channelModel = channelModel;
        this.channelModel.setKey(this.key);
        return new InboundKafkaChannelBuilderImpl(channelModel, this.eventRepository, this);
    }

    public EventDeployment deploy() {
        if (this.resourceName == null) {
            this.resourceName = "inbound-" + this.key + ".channel";
        }
        ChannelModel channelModel = this.buildChannelModel();
        EventDeployment eventDeployment = this.eventRepository.createDeployment().name(this.deploymentName).addChannelDefinition(this.resourceName, this.channelJsonConverter.convertToJson(channelModel)).category(this.category).parentDeploymentId(this.parentDeploymentId).tenantId(this.deploymentTenantId).deploy();
        return eventDeployment;
    }

    protected ChannelModel buildChannelModel() {
        if (this.channelModel == null) {
            this.channelModel = new InboundChannelModel();
        }
        this.channelModel.setKey(this.key);
        return this.channelModel;
    }

    public static class InboundEventTransformerBuilderImpl
    implements InboundChannelModelBuilder.InboundEventTransformerBuilder {
        protected InboundEventProcessingPipelineBuilderImpl inboundEventProcessingPipelineBuilder;

        public InboundEventTransformerBuilderImpl(InboundEventProcessingPipelineBuilderImpl inboundEventProcessingPipelineBuilder) {
            this.inboundEventProcessingPipelineBuilder = inboundEventProcessingPipelineBuilder;
        }

        public InboundChannelModelBuilder transformer(String delegateExpression) {
            this.inboundEventProcessingPipelineBuilder.channelModel.setEventTransformerDelegateExpression(delegateExpression);
            return this.inboundEventProcessingPipelineBuilder.channelDefinitionBuilder;
        }

        public EventDeployment deploy() {
            return this.inboundEventProcessingPipelineBuilder.channelDefinitionBuilder.deploy();
        }
    }

    public static class InboundEventPayloadExtractorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventPayloadExtractorBuilder {
        protected InboundEventProcessingPipelineBuilderImpl inboundEventProcessingPipelineBuilder;

        public InboundEventPayloadExtractorBuilderImpl(InboundEventProcessingPipelineBuilderImpl inboundEventProcessingPipelineBuilder) {
            this.inboundEventProcessingPipelineBuilder = inboundEventProcessingPipelineBuilder;
        }

        public InboundChannelModelBuilder.InboundEventTransformerBuilder payloadExtractor(String delegateExpression) {
            this.inboundEventProcessingPipelineBuilder.channelModel.setPayloadExtractorDelegateExpression(delegateExpression);
            return new InboundEventTransformerBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventPayloadXmlExtractorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventPayloadXmlExtractorBuilder {
        protected InboundEventProcessingPipelineBuilderImpl<Document> inboundEventProcessingPipelineBuilder;

        public InboundEventPayloadXmlExtractorBuilderImpl(InboundEventProcessingPipelineBuilderImpl<Document> inboundEventProcessingPipelineBuilder) {
            this.inboundEventProcessingPipelineBuilder = inboundEventProcessingPipelineBuilder;
        }

        public InboundChannelModelBuilder.InboundEventTransformerBuilder xmlElementsMapDirectlyToPayload() {
            return new InboundEventTransformerBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventPayloadJsonExtractorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventPayloadJsonExtractorBuilder {
        protected InboundEventProcessingPipelineBuilderImpl<JsonNode> inboundEventProcessingPipelineBuilder;

        public InboundEventPayloadJsonExtractorBuilderImpl(InboundEventProcessingPipelineBuilderImpl<JsonNode> inboundEventProcessingPipelineBuilder) {
            this.inboundEventProcessingPipelineBuilder = inboundEventProcessingPipelineBuilder;
        }

        public InboundChannelModelBuilder.InboundEventTransformerBuilder jsonFieldsMapDirectlyToPayload() {
            return new InboundEventTransformerBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventTenantDetectorBuilderImpl
    extends InboundEventPayloadExtractorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventTenantDetectorBuilder {
        public InboundEventTenantDetectorBuilderImpl(InboundEventProcessingPipelineBuilderImpl inboundEventProcessingPipelineBuilder) {
            super(inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventPayloadExtractorBuilder fixedTenantId(String tenantId) {
            ChannelEventTenantIdDetection tenantIdDetection = new ChannelEventTenantIdDetection();
            tenantIdDetection.setFixedValue(tenantId);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventTenantIdDetection(tenantIdDetection);
            return new InboundEventPayloadExtractorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventPayloadExtractorBuilder delegateExpressionTenantDetector(String delegateExpression) {
            ChannelEventTenantIdDetection tenantIdDetection = new ChannelEventTenantIdDetection();
            tenantIdDetection.setDelegateExpression(delegateExpression);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventTenantIdDetection(tenantIdDetection);
            return new InboundEventPayloadExtractorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventTenantXmlDetectorBuilderImpl
    extends InboundEventPayloadXmlExtractorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventTenantXmlDetectorBuilder {
        public InboundEventTenantXmlDetectorBuilderImpl(InboundEventProcessingPipelineBuilderImpl<Document> inboundEventProcessingPipelineBuilder) {
            super(inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventPayloadXmlExtractorBuilder fixedTenantId(String tenantId) {
            ChannelEventTenantIdDetection tenantIdDetection = new ChannelEventTenantIdDetection();
            tenantIdDetection.setFixedValue(tenantId);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventTenantIdDetection(tenantIdDetection);
            return new InboundEventPayloadXmlExtractorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventPayloadXmlExtractorBuilder detectEventTenantUsingXPathExpression(String xPathExpression) {
            ChannelEventTenantIdDetection tenantIdDetection = new ChannelEventTenantIdDetection();
            tenantIdDetection.setxPathExpression(xPathExpression);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventTenantIdDetection(tenantIdDetection);
            return new InboundEventPayloadXmlExtractorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventTenantJsonDetectorBuilderImpl
    extends InboundEventPayloadJsonExtractorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventTenantJsonDetectorBuilder {
        public InboundEventTenantJsonDetectorBuilderImpl(InboundEventProcessingPipelineBuilderImpl<JsonNode> inboundEventProcessingPipelineBuilder) {
            super(inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventPayloadJsonExtractorBuilder fixedTenantId(String tenantId) {
            ChannelEventTenantIdDetection tenantIdDetection = new ChannelEventTenantIdDetection();
            tenantIdDetection.setFixedValue(tenantId);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventTenantIdDetection(tenantIdDetection);
            return new InboundEventPayloadJsonExtractorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventPayloadJsonExtractorBuilder detectEventTenantUsingJsonPointerExpression(String jsonPointerExpression) {
            ChannelEventTenantIdDetection tenantIdDetection = new ChannelEventTenantIdDetection();
            tenantIdDetection.setJsonPointerExpression(jsonPointerExpression);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventTenantIdDetection(tenantIdDetection);
            return new InboundEventPayloadJsonExtractorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventDefinitionKeyDetectorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventKeyDetectorBuilder {
        protected InboundEventProcessingPipelineBuilderImpl inboundEventProcessingPipelineBuilder;

        public InboundEventDefinitionKeyDetectorBuilderImpl(InboundEventProcessingPipelineBuilderImpl inboundEventProcessingPipelineBuilder) {
            this.inboundEventProcessingPipelineBuilder = inboundEventProcessingPipelineBuilder;
        }

        public InboundChannelModelBuilder.InboundEventTenantDetectorBuilder delegateExpressionKeyDetector(String delegateExpression) {
            ChannelEventKeyDetection keyDetection = new ChannelEventKeyDetection();
            keyDetection.setDelegateExpression(delegateExpression);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventKeyDetection(keyDetection);
            return new InboundEventTenantDetectorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventKeyXmlDetectorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventKeyXmlDetectorBuilder {
        protected InboundEventProcessingPipelineBuilderImpl<Document> inboundEventProcessingPipelineBuilder;

        public InboundEventKeyXmlDetectorBuilderImpl(InboundEventProcessingPipelineBuilderImpl<Document> inboundEventProcessingPipelineBuilder) {
            this.inboundEventProcessingPipelineBuilder = inboundEventProcessingPipelineBuilder;
        }

        public InboundChannelModelBuilder.InboundEventTenantXmlDetectorBuilder fixedEventKey(String key) {
            ChannelEventKeyDetection keyDetection = new ChannelEventKeyDetection();
            keyDetection.setFixedValue(key);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventKeyDetection(keyDetection);
            return new InboundEventTenantXmlDetectorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventTenantXmlDetectorBuilder detectEventKeyUsingXPathExpression(String xPathExpression) {
            ChannelEventKeyDetection keyDetection = new ChannelEventKeyDetection();
            keyDetection.setXmlXPathExpression(xPathExpression);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventKeyDetection(keyDetection);
            return new InboundEventTenantXmlDetectorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventKeyJsonDetectorBuilderImpl
    implements InboundChannelModelBuilder.InboundEventKeyJsonDetectorBuilder {
        protected InboundEventProcessingPipelineBuilderImpl<JsonNode> inboundEventProcessingPipelineBuilder;

        public InboundEventKeyJsonDetectorBuilderImpl(InboundEventProcessingPipelineBuilderImpl<JsonNode> inboundEventProcessingPipelineBuilder) {
            this.inboundEventProcessingPipelineBuilder = inboundEventProcessingPipelineBuilder;
        }

        public InboundChannelModelBuilder.InboundEventTenantJsonDetectorBuilder fixedEventKey(String key) {
            ChannelEventKeyDetection keyDetection = new ChannelEventKeyDetection();
            keyDetection.setFixedValue(key);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventKeyDetection(keyDetection);
            return new InboundEventTenantJsonDetectorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventTenantJsonDetectorBuilder detectEventKeyUsingJsonField(String field) {
            ChannelEventKeyDetection keyDetection = new ChannelEventKeyDetection();
            keyDetection.setJsonField(field);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventKeyDetection(keyDetection);
            return new InboundEventTenantJsonDetectorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventTenantJsonDetectorBuilder detectEventKeyUsingJsonPointerExpression(String jsonPointerExpression) {
            ChannelEventKeyDetection keyDetection = new ChannelEventKeyDetection();
            keyDetection.setJsonPointerExpression(jsonPointerExpression);
            this.inboundEventProcessingPipelineBuilder.channelModel.setChannelEventKeyDetection(keyDetection);
            return new InboundEventTenantJsonDetectorBuilderImpl(this.inboundEventProcessingPipelineBuilder);
        }
    }

    public static class InboundEventProcessingPipelineBuilderImpl<T>
    implements InboundChannelModelBuilder.InboundEventProcessingPipelineBuilder {
        protected EventRepositoryService eventRepository;
        protected InboundChannelDefinitionBuilderImpl channelDefinitionBuilder;
        protected InboundChannelModel channelModel;

        public InboundEventProcessingPipelineBuilderImpl(InboundChannelModel channelModel, EventRepositoryService eventRepository, InboundChannelDefinitionBuilderImpl channelDefinitionBuilder) {
            this.channelModel = channelModel;
            this.eventRepository = eventRepository;
            this.channelDefinitionBuilder = channelDefinitionBuilder;
        }

        public InboundChannelModelBuilder.InboundEventKeyJsonDetectorBuilder jsonDeserializer() {
            InboundEventProcessingPipelineBuilderImpl<JsonNode> jsonPipelineBuilder;
            this.channelModel.setDeserializerType("json");
            this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder = jsonPipelineBuilder = new InboundEventProcessingPipelineBuilderImpl<JsonNode>(this.channelModel, this.eventRepository, this.channelDefinitionBuilder);
            return new InboundEventKeyJsonDetectorBuilderImpl(jsonPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventKeyXmlDetectorBuilder xmlDeserializer() {
            InboundEventProcessingPipelineBuilderImpl<Document> xmlPipelineBuilder;
            this.channelModel.setDeserializerType("xml");
            this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder = xmlPipelineBuilder = new InboundEventProcessingPipelineBuilderImpl<Document>(this.channelModel, this.eventRepository, this.channelDefinitionBuilder);
            return new InboundEventKeyXmlDetectorBuilderImpl(xmlPipelineBuilder);
        }

        public InboundChannelModelBuilder.InboundEventKeyDetectorBuilder delegateExpressionDeserializer(String delegateExpression) {
            InboundEventProcessingPipelineBuilderImpl<T> customPipelineBuilder;
            this.channelModel.setDeserializerType("expression");
            this.channelModel.setDeserializerDelegateExpression(delegateExpression);
            this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder = customPipelineBuilder = new InboundEventProcessingPipelineBuilderImpl<T>(this.channelModel, this.eventRepository, this.channelDefinitionBuilder);
            return new InboundEventDefinitionKeyDetectorBuilderImpl(customPipelineBuilder);
        }

        public InboundChannelModelBuilder eventProcessingPipeline(String delegateExpression) {
            this.channelModel.setPipelineDelegateExpression(delegateExpression);
            return this.channelDefinitionBuilder;
        }
    }

    public static class InboundKafkaChannelBuilderImpl
    implements InboundChannelModelBuilder.InboundKafkaChannelBuilder {
        protected final EventRepositoryService eventRepositoryService;
        protected final InboundChannelDefinitionBuilderImpl channelDefinitionBuilder;
        protected KafkaInboundChannelModel kafkaChannel;

        public InboundKafkaChannelBuilderImpl(KafkaInboundChannelModel kafkaChannel, EventRepositoryService eventRepositoryService, InboundChannelDefinitionBuilderImpl channelDefinitionBuilder) {
            this.kafkaChannel = kafkaChannel;
            this.eventRepositoryService = eventRepositoryService;
            this.channelDefinitionBuilder = channelDefinitionBuilder;
        }

        public InboundChannelModelBuilder.InboundKafkaChannelBuilder groupId(String groupId) {
            this.kafkaChannel.setGroupId(groupId);
            return this;
        }

        public InboundChannelModelBuilder.InboundKafkaChannelBuilder clientIdPrefix(String clientIdPrefix) {
            this.kafkaChannel.setClientIdPrefix(clientIdPrefix);
            return this;
        }

        public InboundChannelModelBuilder.InboundKafkaChannelBuilder concurrency(String concurrency) {
            this.kafkaChannel.setConcurrency(concurrency);
            return this;
        }

        public InboundChannelModelBuilder.InboundKafkaChannelBuilder property(String name, String value) {
            this.kafkaChannel.addCustomProperty(name, value);
            return this;
        }

        public InboundChannelModelBuilder.InboundEventProcessingPipelineBuilder eventProcessingPipeline() {
            this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder = new InboundEventProcessingPipelineBuilderImpl((InboundChannelModel)this.kafkaChannel, this.eventRepositoryService, this.channelDefinitionBuilder);
            return this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder;
        }
    }

    public static class InboundRabbitChannelBuilderImpl
    implements InboundChannelModelBuilder.InboundRabbitChannelBuilder {
        protected final EventRepositoryService eventRepositoryService;
        protected final InboundChannelDefinitionBuilderImpl channelDefinitionBuilder;
        protected RabbitInboundChannelModel rabbitChannel;

        public InboundRabbitChannelBuilderImpl(RabbitInboundChannelModel rabbitChannel, EventRepositoryService eventRepositoryService, InboundChannelDefinitionBuilderImpl channelDefinitionBuilder) {
            this.rabbitChannel = rabbitChannel;
            this.eventRepositoryService = eventRepositoryService;
            this.channelDefinitionBuilder = channelDefinitionBuilder;
        }

        public InboundChannelModelBuilder.InboundRabbitChannelBuilder exclusive(boolean exclusive) {
            this.rabbitChannel.setExclusive(exclusive);
            return this;
        }

        public InboundChannelModelBuilder.InboundRabbitChannelBuilder priority(String priority) {
            this.rabbitChannel.setPriority(priority);
            return this;
        }

        public InboundChannelModelBuilder.InboundRabbitChannelBuilder admin(String admin) {
            this.rabbitChannel.setAdmin(admin);
            return this;
        }

        public InboundChannelModelBuilder.InboundRabbitChannelBuilder concurrency(String concurrency) {
            this.rabbitChannel.setConcurrency(concurrency);
            return this;
        }

        public InboundChannelModelBuilder.InboundRabbitChannelBuilder executor(String executor) {
            this.rabbitChannel.setExecutor(executor);
            return this;
        }

        public InboundChannelModelBuilder.InboundRabbitChannelBuilder ackMode(String ackMode) {
            this.rabbitChannel.setAckMode(ackMode);
            return this;
        }

        public InboundChannelModelBuilder.InboundEventProcessingPipelineBuilder eventProcessingPipeline() {
            this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder = new InboundEventProcessingPipelineBuilderImpl((InboundChannelModel)this.rabbitChannel, this.eventRepositoryService, this.channelDefinitionBuilder);
            return this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder;
        }
    }

    public static class InboundJmsChannelBuilderImpl
    implements InboundChannelModelBuilder.InboundJmsChannelBuilder {
        protected final EventRepositoryService eventRepositoryService;
        protected final InboundChannelDefinitionBuilderImpl channelDefinitionBuilder;
        protected JmsInboundChannelModel jmsChannel;

        public InboundJmsChannelBuilderImpl(JmsInboundChannelModel jmsChannel, EventRepositoryService eventRepositoryService, InboundChannelDefinitionBuilderImpl channelDefinitionBuilder) {
            this.jmsChannel = jmsChannel;
            this.eventRepositoryService = eventRepositoryService;
            this.channelDefinitionBuilder = channelDefinitionBuilder;
        }

        public InboundChannelModelBuilder.InboundJmsChannelBuilder selector(String selector) {
            this.jmsChannel.setSelector(selector);
            return this;
        }

        public InboundChannelModelBuilder.InboundJmsChannelBuilder subscription(String subscription) {
            this.jmsChannel.setSubscription(subscription);
            return this;
        }

        public InboundChannelModelBuilder.InboundJmsChannelBuilder concurrency(String concurrency) {
            this.jmsChannel.setConcurrency(concurrency);
            return this;
        }

        public InboundChannelModelBuilder.InboundEventProcessingPipelineBuilder eventProcessingPipeline() {
            this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder = new InboundEventProcessingPipelineBuilderImpl((InboundChannelModel)this.jmsChannel, this.eventRepositoryService, this.channelDefinitionBuilder);
            return this.channelDefinitionBuilder.inboundEventProcessingPipelineBuilder;
        }
    }
}

