/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.factory;

import org.flowable.bpmn.model.Import;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.impl.bpmn.parser.XMLImporter;
import org.flowable.engine.impl.bpmn.parser.factory.XMLImporterFactory;

public class DefaultXMLImporterFactory
implements XMLImporterFactory {
    private static final String DEFAULT_XML_IMPORTER_FACTORY_CLASSNAME = "org.flowable.engine.impl.webservice.CxfWSDLImporter";

    @Override
    public XMLImporter createXMLImporter(Import theImport) throws FlowableException {
        try {
            Class<?> wsdlImporterClass = Class.forName(DEFAULT_XML_IMPORTER_FACTORY_CLASSNAME, true, Thread.currentThread().getContextClassLoader());
            return (XMLImporter)wsdlImporterClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Could not find importer class for type " + theImport.getImportType(), (Throwable)e);
        }
        catch (Exception e) {
            throw new FlowableException(String.format("Error instantiating XML importer '%s' for type '%s'", DEFAULT_XML_IMPORTER_FACTORY_CLASSNAME, theImport.getImportType()), (Throwable)e);
        }
    }
}

