/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCNetworkMessageImpl;
import com.tc.net.protocol.transport.WireProtocolGroupMessage;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessageImpl;
import java.util.ArrayList;
import java.util.Iterator;

public class WireProtocolGroupMessageImpl
extends TCNetworkMessageImpl
implements WireProtocolGroupMessage {
    private final TCConnection sourceConnection;
    private final ArrayList<TCNetworkMessage> messagePayloads;

    public static WireProtocolGroupMessageImpl wrapMessages(ArrayList<TCNetworkMessage> msgPayloads, TCConnection source) {
        WireProtocolHeader header = new WireProtocolHeader();
        header.setProtocol((short)5);
        header.setMessageCount(msgPayloads.size());
        int totalByteBuffers = 0;
        for (int i = 0; i < msgPayloads.size(); ++i) {
            totalByteBuffers += msgPayloads.get(i).getEntireMessageData().length;
        }
        TCByteBuffer[] msgs = new TCByteBuffer[msgPayloads.size() + totalByteBuffers];
        int copyPos = 0;
        for (int i = 0; i < msgPayloads.size(); ++i) {
            TCByteBuffer tcb = TCByteBufferFactory.getInstance(6);
            tcb.putInt(msgPayloads.get(i).getTotalLength());
            tcb.putShort(WireProtocolHeader.getProtocolForMessageClass(msgPayloads.get(i)));
            tcb.flip();
            msgs[copyPos++] = tcb;
            for (int j = 0; j < msgPayloads.get(i).getEntireMessageData().length; ++j) {
                msgs[copyPos++] = msgPayloads.get(i).getEntireMessageData()[j];
            }
        }
        return new WireProtocolGroupMessageImpl(source, header, msgs, msgPayloads);
    }

    protected WireProtocolGroupMessageImpl(TCConnection source, TCNetworkHeader header, TCByteBuffer[] messagePayloadByteBuffers) {
        this(source, header, messagePayloadByteBuffers, null);
    }

    protected WireProtocolGroupMessageImpl(TCConnection source, TCNetworkHeader header, TCByteBuffer[] messagePayloadByteBuffers, ArrayList<TCNetworkMessage> messagePayloads) {
        super(header, messagePayloadByteBuffers);
        this.sourceConnection = source;
        this.messagePayloads = messagePayloads != null ? messagePayloads : this.getMessagesFromByteBuffers(messagePayloadByteBuffers);
        this.recordLength();
    }

    private ArrayList<TCNetworkMessage> getMessagesFromByteBuffers(TCByteBuffer[] messagePayloadByteBuffers) {
        int i;
        byte[] fullMsgsBytes;
        ArrayList<TCNetworkMessage> messages = new ArrayList<TCNetworkMessage>();
        TCByteBuffer[] msgs = messagePayloadByteBuffers;
        if (msgs.length > 1) {
            fullMsgsBytes = new byte[((WireProtocolHeader)this.getHeader()).getTotalPacketLength() - ((WireProtocolHeader)this.getHeader()).getHeaderByteLength()];
            int copyPos = 0;
            for (i = 0; i < msgs.length; ++i) {
                System.arraycopy(msgs[i].array(), 0, fullMsgsBytes, copyPos, msgs[i].limit());
                copyPos += msgs[i].limit();
            }
        } else {
            fullMsgsBytes = msgs[0].array();
        }
        TCByteBuffer b = TCByteBufferFactory.wrap(fullMsgsBytes);
        for (i = 0; i < this.getTotalMessageCount(); ++i) {
            TCByteBuffer[] bufs;
            int msgLen = b.getInt();
            short msgProto = b.getShort();
            for (TCByteBuffer buf : bufs = new TCByteBuffer[]{TCByteBufferFactory.getInstance(msgLen)}) {
                b.get(buf.array(), 0, buf.limit());
            }
            WireProtocolHeader hdr = (WireProtocolHeader)((WireProtocolHeader)this.getHeader()).clone();
            hdr.setTotalPacketLength(hdr.getHeaderByteLength() + msgLen);
            hdr.setProtocol(msgProto);
            hdr.setMessageCount(1);
            hdr.computeChecksum();
            WireProtocolMessageImpl msg = new WireProtocolMessageImpl(this.sourceConnection, hdr, bufs);
            messages.add(msg);
        }
        return messages;
    }

    @Override
    public Iterator<TCNetworkMessage> getMessageIterator() {
        return this.messagePayloads.iterator();
    }

    @Override
    public int getTotalMessageCount() {
        return ((WireProtocolHeader)this.getHeader()).getMessageCount();
    }

    @Override
    public TCConnection getSource() {
        return this.sourceConnection;
    }

    @Override
    public WireProtocolHeader getWireProtocolHeader() {
        return (WireProtocolHeader)this.getHeader();
    }

    @Override
    public short getMessageProtocol() {
        return ((WireProtocolHeader)this.getHeader()).getProtocol();
    }

    protected void recordLength() {
        int packetLength = this.getTotalLength();
        ((WireProtocolHeader)this.getHeader()).setTotalPacketLength(packetLength);
    }

    @Override
    public void complete() {
        this.getMessageIterator().forEachRemaining(TCNetworkMessage::complete);
    }
}

