/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.migrator;

import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.TextResourceOrigin;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertyMigration {
    public static final Comparator<PropertyMigration> COMPARATOR = Comparator.comparing(property -> property.getMetadata().getId());
    private final ConfigurationProperty property;
    private final Integer lineNumber;
    private final ConfigurationMetadataProperty metadata;
    private final ConfigurationMetadataProperty replacementMetadata;
    private final boolean mapMigration;
    private final boolean compatibleType;

    PropertyMigration(ConfigurationProperty property, ConfigurationMetadataProperty metadata, ConfigurationMetadataProperty replacementMetadata, boolean mapMigration) {
        this.property = property;
        this.lineNumber = PropertyMigration.determineLineNumber(property);
        this.metadata = metadata;
        this.replacementMetadata = replacementMetadata;
        this.mapMigration = mapMigration;
        this.compatibleType = PropertyMigration.determineCompatibleType(metadata, replacementMetadata);
    }

    private static Integer determineLineNumber(ConfigurationProperty property) {
        TextResourceOrigin textOrigin;
        Origin origin = property.getOrigin();
        if (origin instanceof TextResourceOrigin && (textOrigin = (TextResourceOrigin)origin).getLocation() != null) {
            return textOrigin.getLocation().getLine() + 1;
        }
        return null;
    }

    private static boolean determineCompatibleType(ConfigurationMetadataProperty metadata, ConfigurationMetadataProperty replacementMetadata) {
        String currentType = PropertyMigration.determineType(metadata);
        String replacementType = PropertyMigration.determineType(replacementMetadata);
        if (currentType == null || replacementType == null) {
            return false;
        }
        if (replacementType.equals(currentType)) {
            return true;
        }
        return replacementType.equals(Duration.class.getName()) && (currentType.equals(Long.class.getName()) || currentType.equals(Integer.class.getName()));
    }

    private static String determineType(ConfigurationMetadataProperty metadata) {
        int lastComma;
        if (metadata == null || metadata.getType() == null) {
            return null;
        }
        String candidate = metadata.getType();
        if (candidate.startsWith(Map.class.getName()) && (lastComma = candidate.lastIndexOf(44)) != -1) {
            return candidate.substring(lastComma + 1, candidate.length() - 1).trim();
        }
        return candidate;
    }

    ConfigurationProperty getProperty() {
        return this.property;
    }

    Integer getLineNumber() {
        return this.lineNumber;
    }

    ConfigurationMetadataProperty getMetadata() {
        return this.metadata;
    }

    boolean isCompatibleType() {
        return this.compatibleType;
    }

    String getNewPropertyName() {
        if (this.mapMigration) {
            return PropertyMigration.getNewMapPropertyName(this.property, this.metadata, this.replacementMetadata).toString();
        }
        return this.metadata.getDeprecation().getReplacement();
    }

    String determineReason() {
        if (this.compatibleType) {
            return "Replacement: " + this.getNewPropertyName();
        }
        Deprecation deprecation = this.metadata.getDeprecation();
        if (StringUtils.hasText((String)deprecation.getShortReason())) {
            return "Reason: " + deprecation.getShortReason();
        }
        if (StringUtils.hasText((String)deprecation.getReplacement())) {
            if (this.replacementMetadata != null) {
                return String.format("Reason: Replacement key '%s' uses an incompatible target type", deprecation.getReplacement());
            }
            return String.format("Reason: No metadata found for replacement key '%s'", deprecation.getReplacement());
        }
        return "Reason: none";
    }

    private static ConfigurationPropertyName getNewMapPropertyName(ConfigurationProperty property, ConfigurationMetadataProperty metadata, ConfigurationMetadataProperty replacement) {
        ConfigurationPropertyName oldName = property.getName();
        ConfigurationPropertyName oldPrefix = ConfigurationPropertyName.of((CharSequence)metadata.getId());
        Assert.state((boolean)oldPrefix.isAncestorOf(oldName), (String)String.format("'%s' is not an ancestor of '%s'", oldPrefix, oldName));
        ConfigurationPropertyName newPrefix = ConfigurationPropertyName.of((CharSequence)replacement.getId());
        return newPrefix.append(oldName.subName(oldPrefix.getNumberOfElements()));
    }
}

