/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.BaseResourceU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class U2FJsonResourceDeviceRepository
extends BaseResourceU2FDeviceRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FJsonResourceDeviceRepository.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    public U2FJsonResourceDeviceRepository(LoadingCache<String, String> requestStorage, CasConfigurationProperties casProperties, CipherExecutor<Serializable, String> cipherExecutor) {
        super(requestStorage, casProperties, cipherExecutor);
        Resource jsonResource = casProperties.getAuthn().getMfa().getU2f().getJson().getLocation();
        if (!ResourceUtils.doesResourceExist((Resource)jsonResource)) {
            FunctionUtils.doUnchecked(u -> {
                if (jsonResource.getFile().createNewFile()) {
                    LOGGER.debug("Created JSON resource [{}] for U2F device registrations", (Object)jsonResource);
                }
            }, (Object[])new Object[0]);
        }
    }

    @Override
    public Map<String, List<U2FDeviceRegistration>> readDevicesFromResource() throws Exception {
        Resource jsonResource = this.casProperties.getAuthn().getMfa().getU2f().getJson().getLocation();
        if (!ResourceUtils.doesResourceExist((Resource)jsonResource)) {
            LOGGER.debug("JSON resource [{}] does not exist or is empty", (Object)jsonResource);
            return new HashMap<String, List<U2FDeviceRegistration>>(0);
        }
        return (Map)MAPPER.readValue(jsonResource.getInputStream(), (TypeReference)new TypeReference<Map<String, List<U2FDeviceRegistration>>>(){});
    }

    @Override
    public void writeDevicesBackToResource(List<U2FDeviceRegistration> list) throws Exception {
        Resource jsonResource = this.casProperties.getAuthn().getMfa().getU2f().getJson().getLocation();
        HashMap<String, List<U2FDeviceRegistration>> newDevices = new HashMap<String, List<U2FDeviceRegistration>>();
        newDevices.put("devices", list);
        MAPPER.writerWithDefaultPrettyPrinter().writeValue(jsonResource.getFile(), newDevices);
        LOGGER.debug("Saved [{}] device(s) into repository [{}]", (Object)list.size(), (Object)jsonResource);
    }

    @Override
    public void removeAll() throws Exception {
        Resource jsonResource = this.casProperties.getAuthn().getMfa().getU2f().getJson().getLocation();
        HashMap newDevices = new HashMap();
        newDevices.put("devices", new ArrayList(0));
        MAPPER.writerWithDefaultPrettyPrinter().writeValue(jsonResource.getFile(), newDevices);
        LOGGER.debug("Removed all device(s) from repository [{}]", (Object)jsonResource);
    }
}

