/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private static final Pattern JAVA_LEGACY_RUNTIME_VERSION = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?(?:_(\\d+))?(?:-(?:.*-)?b(\\d+))?.*");
    private static final Pattern GENERIC_VERSION = Pattern.compile("[^0-9]*(\\d+)\\.(\\d+)(?:\\.(\\d+))?.*");
    private static final String VNUM = "(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)";
    private static final String PRE = "(?:-(?<PRE>[a-zA-Z0-9]+))?";
    private static final String BUILD = "(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?";
    private static final String OPT = "(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
    private static final Pattern JAVA_9_PLUS_VERSION = Pattern.compile("(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?");
    private final int major;
    private final int minor;
    private final int patch;
    private final int update;
    private final int build;

    public Version(int major, int minor, int patch, int update, int build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.update = update;
        this.build = build;
    }

    public static Version parseJavaRuntimeVersion(String javaRuntimeVersion) {
        Matcher matcher = JAVA_9_PLUS_VERSION.matcher(javaRuntimeVersion);
        if (matcher.matches()) {
            String[] version = matcher.group(1).split("\\.");
            int feature = Integer.parseInt(version[0]);
            int interim = version.length > 1 ? Integer.parseInt(version[1]) : 0;
            int update = version.length > 2 ? Integer.parseInt(version[2]) : 0;
            int patch = version.length > 3 ? Integer.parseInt(version[3]) : 0;
            int build = Version.integerOrZero(matcher.group(4));
            return new Version(feature, interim, update, patch, build);
        }
        matcher = JAVA_LEGACY_RUNTIME_VERSION.matcher(javaRuntimeVersion);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Version.integerOrZero(matcher.group(3));
            int update = Version.integerOrZero(matcher.group(4));
            int build = Version.integerOrZero(matcher.group(5));
            return new Version(major, minor, patch, update, build);
        }
        throw new IllegalArgumentException(Version.getUnrecognizedVersionErrorMessage(javaRuntimeVersion));
    }

    public static Version parseVersion(String version) {
        Matcher matcher = GENERIC_VERSION.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Version.integerOrZero(matcher.group(3));
            return new Version(major, minor, patch, 0, 0);
        }
        throw new IllegalArgumentException(Version.getUnrecognizedVersionErrorMessage(version));
    }

    static int integerOrZero(String input) {
        return input != null ? Integer.parseInt(input) : 0;
    }

    private static String getUnrecognizedVersionErrorMessage(String version) {
        String template = "Unrecognized version string '%1$s'.";
        return String.format("Unrecognized version string '%1$s'.", version);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getUpdate() {
        return this.update;
    }

    public int getBuild() {
        return this.build;
    }
}

