/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.Valid;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.DynRoleMembership;
import org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPADynRealm;
import org.apache.syncope.core.persistence.jpa.entity.JPAPrivilege;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.apache.syncope.core.persistence.jpa.entity.user.JPADynRoleMembership;
import org.apache.syncope.core.persistence.jpa.validation.entity.RoleCheck;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="SyncopeRole")
@Cacheable
@RoleCheck
public class JPARole
extends AbstractProvidedKeyEntity
implements Role,
PersistenceCapable {
    private static final long serialVersionUID = -7657701119422588832L;
    public static final String TABLE = "SyncopeRole";
    protected static final TypeReference<Set<String>> TYPEREF = new TypeReference<Set<String>>(){};
    @Lob
    private String entitlements;
    @Transient
    private Set<String> entitlementsSet = new HashSet<String>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="realm_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "realm_id"})})
    @Valid
    private List<JPARealm> realms = new ArrayList<JPARealm>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="dynamicRealm_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "dynamicRealm_id"})})
    @Valid
    private List<JPADynRealm> dynRealms = new ArrayList<JPADynRealm>();
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="role")
    @Valid
    private JPADynRoleMembership dynMembership;
    @Lob
    private String anyLayout;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="privilege_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "privilege_id"})})
    @Valid
    private Set<JPAPrivilege> privileges = new HashSet<JPAPrivilege>();
    private static int pcInheritedFieldCount = AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPADynRoleMembership;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARole;

    public Set<String> getEntitlements() {
        return this.entitlementsSet;
    }

    public boolean add(Realm realm) {
        this.checkType(realm, JPARealm.class);
        return JPARole.pcGetrealms(this).contains((JPARealm)realm) || JPARole.pcGetrealms(this).add((JPARealm)realm);
    }

    public List<? extends Realm> getRealms() {
        return JPARole.pcGetrealms(this);
    }

    public boolean add(DynRealm dynamicRealm) {
        this.checkType(dynamicRealm, JPADynRealm.class);
        return JPARole.pcGetdynRealms(this).contains((JPADynRealm)dynamicRealm) || JPARole.pcGetdynRealms(this).add((JPADynRealm)dynamicRealm);
    }

    public List<? extends DynRealm> getDynRealms() {
        return JPARole.pcGetdynRealms(this);
    }

    public DynRoleMembership getDynMembership() {
        return JPARole.pcGetdynMembership(this);
    }

    public void setDynMembership(DynRoleMembership dynMembership) {
        this.checkType(dynMembership, JPADynRoleMembership.class);
        JPARole.pcSetdynMembership(this, (JPADynRoleMembership)dynMembership);
    }

    public String getAnyLayout() {
        return JPARole.pcGetanyLayout(this);
    }

    public void setAnyLayout(String anyLayout) {
        JPARole.pcSetanyLayout(this, anyLayout);
    }

    public boolean add(Privilege privilege) {
        this.checkType(privilege, JPAPrivilege.class);
        return JPARole.pcGetprivileges(this).add((JPAPrivilege)privilege);
    }

    public Set<? extends Privilege> getPrivileges(Application application) {
        return JPARole.pcGetprivileges(this).stream().filter(privilege -> privilege.getApplication().equals(application)).collect(Collectors.toSet());
    }

    public Set<? extends Privilege> getPrivileges() {
        return JPARole.pcGetprivileges(this);
    }

    protected void json2list(boolean clearFirst) {
        if (clearFirst) {
            this.getEntitlements().clear();
        }
        if (JPARole.pcGetentitlements(this) != null) {
            this.getEntitlements().addAll((Collection)POJOHelper.deserialize((String)JPARole.pcGetentitlements(this), TYPEREF));
        }
    }

    @PostLoad
    public void postLoad() {
        this.json2list(false);
    }

    @PostPersist
    @PostUpdate
    public void postSave() {
        this.json2list(true);
    }

    @PrePersist
    @PreUpdate
    public void list2json() {
        JPARole.pcSetentitlements(this, POJOHelper.serialize(this.getEntitlements()));
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractProvidedKeyEntity = JPARole.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"anyLayout", "dynMembership", "dynRealms", "entitlements", "privileges", "realms"};
        Class[] classArray = new Class[6];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPARole.class$("java.lang.String"));
        classArray[0] = clazz2;
        Class clazz3 = class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPADynRoleMembership != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPADynRoleMembership : (class$Lorg$apache$syncope$core$persistence$jpa$entity$user$JPADynRoleMembership = JPARole.class$("org.apache.syncope.core.persistence.jpa.entity.user.JPADynRoleMembership"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPARole.class$("java.util.List"));
        classArray[2] = clazz4;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPARole.class$("java.lang.String"));
        Class clazz5 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = JPARole.class$("java.util.Set"));
        classArray[4] = clazz5;
        classArray[5] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPARole.class$("java.util.List"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 26, 10, 10};
        Class clazz6 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARole != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARole : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARole = JPARole.class$("org.apache.syncope.core.persistence.jpa.entity.JPARole"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPARole", (PersistenceCapable)new JPARole());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.anyLayout = null;
        this.dynMembership = null;
        this.dynRealms = null;
        this.entitlements = null;
        this.privileges = null;
        this.realms = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPARole jPARole = new JPARole();
        if (bl) {
            jPARole.pcClearFields();
        }
        jPARole.pcStateManager = stateManager;
        jPARole.pcCopyKeyFieldsFromObjectId(object);
        return jPARole;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPARole jPARole = new JPARole();
        if (bl) {
            jPARole.pcClearFields();
        }
        jPARole.pcStateManager = stateManager;
        return jPARole;
    }

    protected static int pcGetManagedFieldCount() {
        return 6 + AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.anyLayout = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.dynMembership = (JPADynRoleMembership)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.dynRealms = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.entitlements = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.privileges = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.realms = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.anyLayout);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.dynMembership);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.dynRealms);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.entitlements);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.privileges);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.realms);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPARole jPARole, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPARole, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.anyLayout = jPARole.anyLayout;
                return;
            }
            case 1: {
                this.dynMembership = jPARole.dynMembership;
                return;
            }
            case 2: {
                this.dynRealms = jPARole.dynRealms;
                return;
            }
            case 3: {
                this.entitlements = jPARole.entitlements;
                return;
            }
            case 4: {
                this.privileges = jPARole.privileges;
                return;
            }
            case 5: {
                this.realms = jPARole.realms;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPARole jPARole = (JPARole)object;
        if (jPARole.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPARole, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARole != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARole : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARole = JPARole.class$("org.apache.syncope.core.persistence.jpa.entity.JPARole"));
        return clazz;
    }

    private static final String pcGetanyLayout(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.anyLayout;
        }
        int n = pcInheritedFieldCount + 0;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.anyLayout;
    }

    private static final void pcSetanyLayout(JPARole jPARole, String string) {
        if (jPARole.pcStateManager == null) {
            jPARole.anyLayout = string;
            return;
        }
        jPARole.pcStateManager.settingStringField((PersistenceCapable)jPARole, pcInheritedFieldCount + 0, jPARole.anyLayout, string, 0);
    }

    private static final JPADynRoleMembership pcGetdynMembership(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.dynMembership;
        }
        int n = pcInheritedFieldCount + 1;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.dynMembership;
    }

    private static final void pcSetdynMembership(JPARole jPARole, JPADynRoleMembership jPADynRoleMembership) {
        if (jPARole.pcStateManager == null) {
            jPARole.dynMembership = jPADynRoleMembership;
            return;
        }
        jPARole.pcStateManager.settingObjectField((PersistenceCapable)jPARole, pcInheritedFieldCount + 1, (Object)jPARole.dynMembership, (Object)jPADynRoleMembership, 0);
    }

    private static final List pcGetdynRealms(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.dynRealms;
        }
        int n = pcInheritedFieldCount + 2;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.dynRealms;
    }

    private static final void pcSetdynRealms(JPARole jPARole, List list) {
        if (jPARole.pcStateManager == null) {
            jPARole.dynRealms = list;
            return;
        }
        jPARole.pcStateManager.settingObjectField((PersistenceCapable)jPARole, pcInheritedFieldCount + 2, jPARole.dynRealms, (Object)list, 0);
    }

    private static final String pcGetentitlements(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.entitlements;
        }
        int n = pcInheritedFieldCount + 3;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.entitlements;
    }

    private static final void pcSetentitlements(JPARole jPARole, String string) {
        if (jPARole.pcStateManager == null) {
            jPARole.entitlements = string;
            return;
        }
        jPARole.pcStateManager.settingStringField((PersistenceCapable)jPARole, pcInheritedFieldCount + 3, jPARole.entitlements, string, 0);
    }

    private static final Set pcGetprivileges(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.privileges;
        }
        int n = pcInheritedFieldCount + 4;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.privileges;
    }

    private static final void pcSetprivileges(JPARole jPARole, Set set) {
        if (jPARole.pcStateManager == null) {
            jPARole.privileges = set;
            return;
        }
        jPARole.pcStateManager.settingObjectField((PersistenceCapable)jPARole, pcInheritedFieldCount + 4, jPARole.privileges, (Object)set, 0);
    }

    private static final List pcGetrealms(JPARole jPARole) {
        if (jPARole.pcStateManager == null) {
            return jPARole.realms;
        }
        int n = pcInheritedFieldCount + 5;
        jPARole.pcStateManager.accessingField(n);
        return jPARole.realms;
    }

    private static final void pcSetrealms(JPARole jPARole, List list) {
        if (jPARole.pcStateManager == null) {
            jPARole.realms = list;
            return;
        }
        jPARole.pcStateManager.settingObjectField((PersistenceCapable)jPARole, pcInheritedFieldCount + 5, jPARole.realms, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

