/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Activatable;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.DropDownJqueryFunction;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownAlignmentBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownVariationBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuDivider;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.function.IFunction;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public abstract class DropDownButton
extends AbstractLink
implements Activatable {
    private static final long serialVersionUID = 1L;
    private ButtonList buttonListView;
    private WebMarkupContainer baseButton;
    private Icon icon;
    private final IModel<IconType> iconType;
    private ButtonBehavior buttonBehavior;
    private DropDownVariationBehavior dropDownVariation;
    private DropDownAlignmentBehavior dropDownAlignment;

    public DropDownButton(String id, IModel<String> model) {
        this(id, model, (IModel<IconType>)Model.of((Serializable)((Object)((IconType)null))));
    }

    public DropDownButton(String markupId, IModel<String> model, IModel<IconType> iconType) {
        super(markupId, model);
        this.iconType = iconType;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.getButton()});
        this.add(new Behavior[]{this.getDropDownVariation()});
        WebMarkupContainer dropdownMenu = new WebMarkupContainer("dropdown-menu");
        dropdownMenu.add(new Behavior[]{new AttributeModifier("aria-labelledby", (IModel & Serializable)() -> this.getButton().getMarkupId(true))});
        this.add(new Component[]{dropdownMenu});
        dropdownMenu.add(new Component[]{this.getButtonList()});
        dropdownMenu.add(new Behavior[]{this.getDropDownAlignment()});
        BootstrapResourcesBehavior.addTo((Component)this);
        this.addIconToBaseButton(this.getIcon());
        this.addButtonBehavior(this.getButtonBehavior());
    }

    public IModel<String> getModel() {
        return this.getDefaultModel();
    }

    private WebMarkupContainer getButton() {
        if (this.baseButton == null) {
            this.baseButton = this.newButton("btn", this.getModel(), this.iconType);
        }
        return this.baseButton;
    }

    private ButtonList getButtonList() {
        if (this.buttonListView == null) {
            this.buttonListView = this.newButtonList("buttons");
        }
        return this.buttonListView;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.newButtonIcon("icon", this.iconType);
        }
        return this.icon;
    }

    private ButtonBehavior getButtonBehavior() {
        if (this.buttonBehavior == null) {
            this.buttonBehavior = new ButtonBehavior(Buttons.Type.Secondary, Buttons.Size.Medium);
        }
        return this.buttonBehavior;
    }

    private DropDownVariationBehavior getDropDownVariation() {
        if (this.dropDownVariation == null) {
            this.dropDownVariation = new DropDownVariationBehavior(DropDownVariationBehavior.Variation.DROPDOWN);
        }
        return this.dropDownVariation;
    }

    private DropDownAlignmentBehavior getDropDownAlignment() {
        if (this.dropDownAlignment == null) {
            this.dropDownAlignment = new DropDownAlignmentBehavior(DropDownAlignmentBehavior.Alignment.NONE);
        }
        return this.dropDownAlignment;
    }

    protected String createCssClassName() {
        return "btn-group";
    }

    protected void addIconToBaseButton(Icon icon) {
        this.getButton().add(new Component[]{this.getIcon()});
    }

    public final DropDownButton addToButton(Behavior behavior) {
        this.getButton().add(new Behavior[]{behavior});
        return this;
    }

    protected String newInitializerScript() {
        JQuery jQuery = JQuery.$((Component)this.getButton());
        return jQuery.chain((IFunction)DropDownJqueryFunction.dropdown()).get();
    }

    public final void appendToggleMenuScript(IPartialPageRequestHandler target) {
        target.appendJavaScript((CharSequence)JQuery.$((Component)this, (CharSequence[])new CharSequence[]{".dropdown-toggle"}).chain((IFunction)DropDownJqueryFunction.dropdown("toggle")).get());
    }

    public final DropDownButton setIconType(IconType iconType) {
        this.getIcon().setType(iconType);
        return this;
    }

    protected WebMarkupContainer newButton(String markupId, IModel<String> labelModel, IModel<IconType> iconTypeModel) {
        WebMarkupContainer baseButton = new WebMarkupContainer(markupId);
        baseButton.setOutputMarkupId(true);
        baseButton.add(new Component[]{this.newButtonLabel("label", this.wrap(labelModel))});
        return baseButton;
    }

    protected Component newButtonLabel(String markupId, IModel<?> labelModel) {
        Label label = new Label(markupId, this.wrap(labelModel));
        label.setRenderBodyOnly(true);
        return label;
    }

    protected Icon newButtonIcon(String markupId, IModel<IconType> iconTypeModel) {
        return new Icon(markupId, iconTypeModel);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String script = this.newInitializerScript();
        if (!Strings.isEmpty((CharSequence)script)) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
        }
    }

    protected void addButtonBehavior(ButtonBehavior buttonBehavior) {
        this.getButton().add(new Behavior[]{buttonBehavior});
    }

    protected abstract List<AbstractLink> newSubMenuButtons(String var1);

    protected ButtonList newButtonList(String markupId) {
        ButtonList buttonList = new ButtonList(markupId, this.newSubMenuButtons(ButtonList.getButtonMarkupId())){

            @Override
            protected void configureLink(AbstractLink link) {
                super.configureLink(link);
                if (!(link instanceof MenuDivider)) {
                    link.add(new Behavior[]{new CssClassNameAppender("dropdown-item")});
                }
            }
        };
        buttonList.setRenderBodyOnly(true);
        buttonList.setOutputMarkupId(false);
        return buttonList;
    }

    public DropDownButton setSize(Buttons.Size size) {
        this.getButtonBehavior().setSize(size);
        return this;
    }

    public DropDownButton setType(Buttons.Type type) {
        this.getButtonBehavior().setType(type);
        return this;
    }

    public DropDownButton setAlignment(DropDownAlignmentBehavior.Alignment alignment) {
        this.getDropDownAlignment().setAlignment(alignment);
        return this;
    }

    public DropDownButton setVariation(DropDownVariationBehavior.Variation variation) {
        this.getDropDownVariation().setVariation(variation);
        return this;
    }

    protected final IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(false);
    }

    protected void onComponentTag(ComponentTag tag) {
        if (!Components.hasTagName(tag, "div", "li")) {
            tag.setName("div");
        }
        super.onComponentTag(tag);
        Attributes.addClass(tag, this.createCssClassName());
    }

    @Override
    public boolean isActive(Component item) {
        return this.getButtonList().hasActiveButton(item);
    }
}

