/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.aup.AcceptableUsagePolicyStatus;
import org.apereo.cas.aup.AcceptableUsagePolicyTerms;
import org.apereo.cas.aup.BaseAcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.RequestContext;

public class GroovyAcceptableUsagePolicyRepository
extends BaseAcceptableUsagePolicyRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyAcceptableUsagePolicyRepository.class);
    private static final long serialVersionUID = 2773808902502739L;
    private final transient WatchableGroovyScriptResource watchableScript;
    private final transient ApplicationContext applicationContext;

    public GroovyAcceptableUsagePolicyRepository(TicketRegistrySupport ticketRegistrySupport, AcceptableUsagePolicyProperties aupProperties, WatchableGroovyScriptResource watchableScript, ApplicationContext applicationContext) {
        super(ticketRegistrySupport, aupProperties);
        this.watchableScript = watchableScript;
        this.applicationContext = applicationContext;
    }

    @Override
    public AcceptableUsagePolicyStatus verify(RequestContext requestContext) {
        Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
        return (AcceptableUsagePolicyStatus)this.watchableScript.execute("verify", AcceptableUsagePolicyStatus.class, new Object[]{requestContext, this.applicationContext, principal, LOGGER});
    }

    @Override
    public Optional<AcceptableUsagePolicyTerms> fetchPolicy(RequestContext requestContext) {
        try {
            Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
            AcceptableUsagePolicyTerms result = (AcceptableUsagePolicyTerms)this.watchableScript.execute("fetch", AcceptableUsagePolicyTerms.class, new Object[]{requestContext, this.applicationContext, principal, LOGGER});
            return Optional.ofNullable(result);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public boolean submit(RequestContext requestContext) {
        Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
        return (Boolean)this.watchableScript.execute("submit", Boolean.class, new Object[]{requestContext, this.applicationContext, principal, LOGGER});
    }
}

