/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class AttributesAccessor {
    private final Map<String, Attribute> attributeMap;

    public AttributesAccessor(Set<Attribute> attrs) {
        this.attributeMap = AttributeUtil.toMap(attrs);
    }

    public Attribute find(String name) {
        return this.attributeMap.get(name);
    }

    public Name getName() {
        return (Name)this.find(Name.NAME);
    }

    public Uid getUid() {
        return (Uid)this.find(Uid.NAME);
    }

    public boolean getEnabled(boolean defaultTo) {
        boolean result = defaultTo;
        Attribute enable = this.find(OperationalAttributes.ENABLE_NAME);
        if (enable != null) {
            result = AttributeUtil.getBooleanValue(enable);
        }
        return result;
    }

    public GuardedString getPassword() {
        Attribute attribute = this.find(OperationalAttributes.PASSWORD_NAME);
        return attribute == null ? null : AttributeUtil.getGuardedStringValue(attribute);
    }

    public List<Object> findList(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : attribute.getValue();
    }

    public List<String> findStringList(String name) {
        List<Object> list = this.findList(name);
        if (list != null) {
            ArrayList<String> ret = new ArrayList<String>(list.size());
            for (Object o : list) {
                ret.add((String)o);
            }
            return ret;
        }
        return null;
    }

    public Set<String> listAttributeNames() {
        SortedSet<String> names = CollectionUtil.newCaseInsensitiveSet();
        names.addAll(this.attributeMap.keySet());
        return Collections.unmodifiableSet(names);
    }

    public boolean hasAttribute(String name) {
        return this.find(name) != null;
    }

    public String findString(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getStringValue(attribute);
    }

    public Character findCharacter(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getCharacterValue(attribute);
    }

    public Integer findInteger(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getIntegerValue(attribute);
    }

    public Long findLong(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getLongValue(attribute);
    }

    public Date findDate(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getDateValue(attribute);
    }

    public Double findDouble(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getDoubleValue(attribute);
    }

    public Float findFloat(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getFloatValue(attribute);
    }

    public BigDecimal findBigDecimal(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getBigDecimalValue(attribute);
    }

    public Boolean findBoolean(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getBooleanValue(attribute);
    }

    public Byte findByte(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getByteValue(attribute);
    }

    public Byte[] findByteArray(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getByteArrayValue(attribute);
    }

    public BigInteger findBigInteger(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getBigIntegerValue(attribute);
    }

    public GuardedByteArray findGuardedByteArray(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getGuardedByteArrayValue(attribute);
    }

    public GuardedString findGuardedString(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getGuardedStringValue(attribute);
    }

    public Map<String, Object> findMap(String name) {
        Attribute attribute = this.find(name);
        return attribute == null ? null : AttributeUtil.getMapValue(attribute);
    }
}

