/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.LinkedHashMap;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

public final class ScriptContext {
    private final String scriptLanguage;
    private final String scriptText;
    private final Map<String, Object> scriptArguments;

    public ScriptContext(String scriptLanguage, String scriptText, Map<String, Object> scriptArguments) {
        if (StringUtil.isBlank(scriptLanguage)) {
            throw new IllegalArgumentException("Argument 'scriptLanguage' must be specified");
        }
        if (StringUtil.isBlank(scriptText)) {
            throw new IllegalArgumentException("Argument 'scriptText' must be specified");
        }
        Map scriptArgumentsClone = (Map)SerializerUtil.cloneObject(scriptArguments);
        this.scriptLanguage = scriptLanguage;
        this.scriptText = scriptText;
        this.scriptArguments = CollectionUtil.asReadOnlyMap(scriptArgumentsClone);
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public Map<String, Object> getScriptArguments() {
        return this.scriptArguments;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("ScriptContext: ");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Language", this.getScriptLanguage());
        map.put("Text", this.getScriptText());
        map.put("Arguments", this.getScriptArguments());
        bld.append(((Object)map).toString());
        return bld.toString();
    }
}

