/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.tool.xmlsectool.CommandLineArguments;
import net.shibboleth.tool.xmlsectool.CredentialHelper;
import net.shibboleth.tool.xmlsectool.InitializationSupport;
import net.shibboleth.tool.xmlsectool.ReturnCode;
import net.shibboleth.tool.xmlsectool.SchemaValidator;
import net.shibboleth.tool.xmlsectool.SignatureHelper;
import net.shibboleth.tool.xmlsectool.Terminator;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.SchemaBuilder;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.reference.ReferenceData;
import org.apache.xml.security.signature.reference.ReferenceSubTreeData;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.opensaml.core.config.InitializationException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XMLSecTool {
    private static Logger log;

    private XMLSecTool() {
    }

    public static void main(String[] args) {
        try {
            X509Credential cred;
            CommandLineArguments cli = new CommandLineArguments();
            cli.parseCommandLineArguments(args);
            XMLSecTool.initLogging(cli);
            cli.checkForDeprecations();
            try {
                InitializationSupport.initialize();
            }
            catch (InitializationException e) {
                log.error("Unable to initialize OpenSAML library", (Throwable)e);
                throw new Terminator(ReturnCode.RC_INIT);
            }
            if (cli.doHelp()) {
                cli.printHelp(System.out);
                return;
            }
            if (cli.doListAlgorithms()) {
                cli.getDisallowedAlgorithms().list(System.out);
                return;
            }
            Document xml = XMLSecTool.parseXML(cli);
            if (cli.doSchemaValidation()) {
                XMLSecTool.schemaValidate(cli, xml);
            }
            if (cli.doSign()) {
                cred = XMLSecTool.getCredential(cli);
                XMLSecTool.sign(cli, cred, xml);
            }
            if (cli.doSignatureVerify()) {
                cred = XMLSecTool.getCredential(cli);
                XMLSecTool.verifySignature(cli, cred, xml);
            }
            if (cli.getOutputFile() != null) {
                XMLSecTool.writeDocument(cli, xml);
            }
        }
        catch (Terminator t) {
            System.exit(t.getExitCode());
        }
        catch (Throwable t) {
            log.error("Unknown error", t);
            System.exit(ReturnCode.RC_UNKNOWN.getCode());
        }
    }

    protected static Document parseXML(CommandLineArguments cli) {
        InputStream xmlInputStream = cli.getInputFile() != null ? XMLSecTool.getXmlInputStreamFromFile(cli) : XMLSecTool.getXmlInputStreamFromUrl(cli);
        DocumentBuilder xmlParser = XMLSecTool.getParser();
        try {
            log.debug("Parsing XML input stream");
            Document xmlDoc = xmlParser.parse(xmlInputStream);
            log.info("XML document parsed and is well-formed.");
            return xmlDoc;
        }
        catch (IOException e) {
            log.error("Error reading XML document from input source", (Throwable)e);
            throw new Terminator(ReturnCode.RC_IO);
        }
        catch (SAXException e) {
            log.error("XML document was not well formed", (Throwable)e);
            throw new Terminator(ReturnCode.RC_MALFORMED_XML);
        }
    }

    protected static InputStream getXmlInputStreamFromFile(CommandLineArguments cli) {
        try {
            log.info("Reading XML document from file '{}'", (Object)cli.getInputFile());
            File inputFile = new File(cli.getInputFile());
            if (!inputFile.exists()) {
                log.error("Input file '{}' does not exist", (Object)cli.getInputFile());
                throw new Terminator(ReturnCode.RC_IO);
            }
            if (inputFile.isDirectory()) {
                log.error("Input file '{}' is a directory", (Object)cli.getInputFile());
                throw new Terminator(ReturnCode.RC_IO);
            }
            if (!inputFile.canRead()) {
                log.error("Input file '{}' can not be read", (Object)cli.getInputFile());
                throw new Terminator(ReturnCode.RC_IO);
            }
            InputStream ins = new FileInputStream(cli.getInputFile());
            if (cli.isBase64DecodeInput()) {
                log.debug("Passing input file through Base64 decoder.");
                ins = new Base64InputStream(ins);
            }
            if (cli.isInflateInput()) {
                log.debug("Passing input file data through Inflater decompression filter");
                ins = new InflaterInputStream(ins);
            }
            if (cli.isGunzipInput()) {
                log.debug("Passing input file data through GZip decompression filter");
                ins = new GZIPInputStream(ins);
            }
            return ins;
        }
        catch (IOException e) {
            log.error("Unable to read input file '{}'", (Object)cli.getInputFile(), (Object)e);
            throw new Terminator(ReturnCode.RC_IO);
        }
    }

    protected static InputStream getXmlInputStreamFromUrl(CommandLineArguments cli) {
        log.info("Reading XML document from URL '{}'", (Object)cli.getInputUrl());
        HttpClientBuilder httpClientBuilder = new HttpClientBuilder();
        httpClientBuilder.setConnectionDisregardTLSCertificate(true);
        if (cli.getHttpProxy() != null) {
            httpClientBuilder.setConnectionProxyHost(cli.getHttpProxy());
            httpClientBuilder.setConnectionProxyPort(cli.getHttpProxyPort());
            httpClientBuilder.setConnectionProxyUsername(cli.getHttpProxyUsername());
            httpClientBuilder.setConnectionProxyPassword(cli.getHttpProxyPassword());
        }
        HttpGet getMethod = new HttpGet(cli.getInputUrl());
        getMethod.setHeader("Accept-Encoding", "gzip,deflate");
        try {
            HttpClient httpClient = httpClientBuilder.buildClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                log.error("Non-ok status code '" + Integer.valueOf(status) + "' returned by '" + cli.getInputUrl() + "'");
                throw new Terminator(ReturnCode.RC_IO);
            }
            InputStream ins = response.getEntity().getContent();
            Header contentEncodingHeader = response.getFirstHeader("Content-Encoding");
            if (contentEncodingHeader != null) {
                String contentEncoding = contentEncodingHeader.getValue();
                if ("deflate".equalsIgnoreCase(contentEncoding)) {
                    log.debug("Passing input file data through Inflater decompression filter");
                    ins = new InflaterInputStream(ins);
                }
                if ("gzip".equalsIgnoreCase(contentEncoding)) {
                    log.debug("Passing input file data through GZip decompression filter");
                    ins = new GZIPInputStream(ins);
                }
            }
            if (cli.isBase64DecodeInput()) {
                log.debug("Passing input file through Base64 decoder.");
                ins = new Base64InputStream(ins);
            }
            return ins;
        }
        catch (IOException e) {
            log.error("Unable to read XML document from " + cli.getInputUrl(), (Throwable)e);
        }
        catch (Exception e) {
            log.error("error building an HTTP client instance for " + cli.getInputUrl(), (Throwable)e);
        }
        throw new Terminator(ReturnCode.RC_IO);
    }

    protected static DocumentBuilder getParser() {
        log.debug("Building DOM parser");
        DocumentBuilderFactory newFactory = DocumentBuilderFactory.newInstance();
        newFactory.setCoalescing(false);
        newFactory.setExpandEntityReferences(true);
        newFactory.setIgnoringComments(false);
        newFactory.setIgnoringElementContentWhitespace(false);
        newFactory.setNamespaceAware(true);
        newFactory.setValidating(false);
        newFactory.setXIncludeAware(false);
        try {
            return newFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("Unable to create XML parser", (Throwable)e);
            throw new Terminator(ReturnCode.RC_UNKNOWN);
        }
    }

    protected static void schemaValidate(CommandLineArguments cli, Document xml) {
        SchemaValidator validator;
        SchemaBuilder.SchemaLanguage schemaLanguage = cli.isXsdSchema() ? SchemaBuilder.SchemaLanguage.XML : SchemaBuilder.SchemaLanguage.RELAX;
        File schemaFileOrDirectory = new File(cli.getSchemaDirectory());
        try {
            log.debug("Building W3 XML Schema from file/directory '{}'", (Object)schemaFileOrDirectory.getAbsolutePath());
            validator = new SchemaValidator(schemaLanguage, schemaFileOrDirectory);
        }
        catch (SAXException e) {
            log.error("Invalid XML schema files, unable to validate XML", (Throwable)e);
            throw new Terminator(ReturnCode.RC_INVALID_XS);
        }
        try {
            log.debug("Schema validating XML document");
            validator.validate(new DOMSource(xml));
            log.info("XML document is schema valid");
        }
        catch (SAXException e) {
            log.error("XML is not schema valid", (Throwable)e);
            throw new Terminator(ReturnCode.RC_INVALID_XML);
        }
        catch (IOException e) {
            log.error("internal error: I/O exception while validating XML", (Throwable)e);
            throw new Terminator(ReturnCode.RC_INVALID_XML);
        }
    }

    protected static void sign(@Nonnull CommandLineArguments cli, @Nonnull X509Credential signingCredential, @Nonnull Document xml) {
        log.debug("Preparing to sign document");
        Element documentRoot = xml.getDocumentElement();
        Element signatureElement = XMLSecTool.getSignatureElement(xml);
        if (signatureElement != null) {
            log.error("XML document is already signed");
            throw new Terminator(ReturnCode.RC_SIG);
        }
        String signatureAlgorithm = XMLSecTool.determineSignatureAlgorithm(cli, signingCredential);
        log.debug("signature algorithm {} selected from credential+digest", (Object)signatureAlgorithm);
        SignatureSigningConfiguration securityConfig = SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration();
        boolean hmac = AlgorithmSupport.isHMAC((String)signatureAlgorithm);
        Integer hmacOutputLength = securityConfig.getSignatureHMACOutputLength();
        String digestAlgorithm = cli.getDigestAlgorithm();
        if (digestAlgorithm == null) {
            digestAlgorithm = cli.getDigest().getDigestAlgorithm();
        }
        String c14nAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        try {
            XMLSignature signature = hmac ? new XMLSignature(xml, "#", signatureAlgorithm, hmacOutputLength.intValue(), "http://www.w3.org/2001/10/xml-exc-c14n#") : new XMLSignature(xml, "#", signatureAlgorithm, "http://www.w3.org/2001/10/xml-exc-c14n#");
            XMLSecTool.populateKeyInfo(xml, signature.getKeyInfo(), signingCredential);
            Transforms contentTransforms = new Transforms(xml);
            contentTransforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            contentTransforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.addDocument(XMLSecTool.getSignatureReferenceUri(cli, documentRoot), contentTransforms, digestAlgorithm);
            log.debug("Creating Signature DOM element");
            signatureElement = signature.getElement();
            XMLSecTool.addSignatureELement(cli, documentRoot, signatureElement);
            signature.sign(CredentialSupport.extractSigningKey((Credential)signingCredential));
            SignatureHelper.postProcessSignature(signatureElement);
            log.info("XML document successfully signed");
        }
        catch (XMLSecurityException e) {
            log.error("Unable to create XML document signature", (Throwable)e);
            throw new Terminator(ReturnCode.RC_SIG);
        }
    }

    protected static String determineSignatureAlgorithm(@Nonnull CommandLineArguments cli, @Nonnull X509Credential signingCredential) {
        if (cli.getSignatureAlgorithm() != null) {
            return cli.getSignatureAlgorithm();
        }
        String credentialAlgorithm = signingCredential.getPublicKey().getAlgorithm();
        log.debug("credential public key algorithm is {}", (Object)credentialAlgorithm);
        switch (credentialAlgorithm) {
            case "RSA": {
                return cli.getDigest().getRSAAlgorithm();
            }
            case "EC": {
                return cli.getDigest().getECDSAAlgorithm();
            }
            case "DSA": {
                return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
        }
        log.error("unimplemented signing credential type: {}", (Object)credentialAlgorithm);
        throw new Terminator(ReturnCode.RC_SIG);
    }

    protected static void populateKeyInfo(Document doc, KeyInfo keyInfo, X509Credential credential) {
        PublicKey pk;
        if (credential.getKeyNames() != null) {
            for (String name : credential.getKeyNames()) {
                KeyName keyName = new KeyName(doc, name);
                keyInfo.add(keyName);
            }
        }
        if ((pk = credential.getPublicKey()) instanceof RSAPublicKey || pk instanceof DSAPublicKey) {
            keyInfo.add(pk);
        } else {
            log.debug("not adding KeyValue for unsupported credential of type " + pk.getAlgorithm());
        }
        X509Data x509Data = new X509Data(doc);
        keyInfo.add(x509Data);
        try {
            for (X509Certificate cert : credential.getEntityCertificateChain()) {
                x509Data.addCertificate(cert);
            }
            if (credential.getCRLs() != null) {
                for (X509CRL crl : credential.getCRLs()) {
                    x509Data.addCRL(crl.getEncoded());
                }
            }
        }
        catch (XMLSecurityException e) {
            log.error("Unable to constructor signature KeyInfo", (Throwable)e);
            throw new Terminator(ReturnCode.RC_UNKNOWN);
        }
        catch (CRLException cRLException) {
            // empty catch block
        }
    }

    protected static String getSignatureReferenceUri(CommandLineArguments cli, Element rootElement) {
        Attr referenceAttribute;
        Object reference = "";
        if (cli.getReferenceIdAttributeName() != null && (referenceAttribute = (Attr)rootElement.getAttributes().getNamedItem(cli.getReferenceIdAttributeName())) != null) {
            rootElement.setIdAttributeNode(referenceAttribute, true);
            reference = StringSupport.trim((String)referenceAttribute.getValue());
            if (((String)reference).length() > 0) {
                reference = "#" + (String)reference;
            }
        }
        return reference;
    }

    protected static void addSignatureELement(CommandLineArguments cli, Element root, Element signature) {
        if ("FIRST".equalsIgnoreCase(cli.getSignaturePosition()) || cli.getSignaturePosition() == null) {
            root.insertBefore(signature, root.getFirstChild());
            return;
        }
        if ("LAST".equalsIgnoreCase(cli.getSignaturePosition())) {
            root.appendChild(signature);
            return;
        }
        try {
            NodeList children = root.getChildNodes();
            int position = Integer.parseInt(cli.getSignaturePosition());
            boolean signatureInserted = false;
            if (children.getLength() > position) {
                int elementCount = 0;
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1 || ++elementCount != position) continue;
                    root.insertBefore(signature, children.item(i));
                    signatureInserted = true;
                }
            }
            if (!signatureInserted) {
                root.appendChild(signature);
            }
        }
        catch (NumberFormatException e) {
            log.error("Invalid signature position: " + cli.getSignaturePosition());
            throw new Terminator(ReturnCode.RC_SIG);
        }
    }

    protected static void markIdAttribute(Element docElement, Reference reference) {
        String referenceUri = reference.getURI();
        if (referenceUri == null || referenceUri.trim().isEmpty()) {
            log.debug("reference was empty; no ID marking required");
            return;
        }
        if (AttributeSupport.getIdAttribute((Element)docElement) != null) {
            log.debug("document element already has an ID attribute");
            return;
        }
        if (!referenceUri.startsWith("#")) {
            log.error("Signature Reference URI was not a document fragment reference: " + referenceUri);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        String id = referenceUri.substring(1);
        NamedNodeMap attributes = docElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!id.equals(attribute.getValue())) continue;
            log.debug("marking ID attribute {}", (Object)attribute.getName());
            docElement.setIdAttributeNode(attribute, true);
            return;
        }
        log.warn("did not find a document element attribute with value '{}'", (Object)id);
    }

    protected static void verifySignature(CommandLineArguments cli, @Nonnull X509Credential credential, Document xmlDocument) {
        String alg;
        XMLSignature signature;
        Element signatureElement = XMLSecTool.getSignatureElement(xmlDocument);
        if (signatureElement == null) {
            log.error("Signature required but XML document is not signed");
            throw new Terminator(ReturnCode.RC_SIG);
        }
        log.debug("XML document contained Signature element\n{}", (Object)SerializeSupport.prettyPrintXML((Node)signatureElement));
        log.debug("Creating XML security library XMLSignature object");
        try {
            signature = new XMLSignature(signatureElement, "");
        }
        catch (XMLSecurityException e) {
            log.error("Unable to read XML signature", (Throwable)e);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        if (signature.getObjectLength() != 0) {
            log.error("Signature contained an Object element, this is not allowed");
            throw new Terminator(ReturnCode.RC_SIG);
        }
        Reference ref = XMLSecTool.extractReference(signature);
        XMLSecTool.markIdAttribute(xmlDocument.getDocumentElement(), ref);
        try {
            alg = ref.getMessageDigestAlgorithm().getAlgorithmURI();
            log.debug("checking digest {} allowed", (Object)alg);
            if (cli.getDisallowedAlgorithms().isDigestAlgorithmDisallowed(alg)) {
                log.error("Digest algorithm {} is disallowed", (Object)alg);
                throw new Terminator(ReturnCode.RC_SIG);
            }
        }
        catch (XMLSignatureException e) {
            log.error("unable to retrieve signature digest algorithm", (Throwable)e);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        alg = signature.getSignedInfo().getSignatureMethodURI();
        log.debug("checking signature method {} is allowed", (Object)alg);
        if (cli.getDisallowedAlgorithms().isSignatureAlgorithmDisallowed(alg)) {
            log.error("Signature algorithm {} is disallowed", (Object)alg);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        Key verificationKey = CredentialSupport.extractVerificationKey((Credential)credential);
        log.debug("Verifying XML signature with key\n{}", (Object)Base64.encodeBase64String((byte[])verificationKey.getEncoded()));
        try {
            if (!signature.checkSignatureValue(verificationKey)) {
                log.error("XML document signature verification failed");
                throw new Terminator(ReturnCode.RC_SIG);
            }
            XMLSecTool.validateSignatureReference(xmlDocument, XMLSecTool.extractReference(signature));
            log.info("XML document signature verified.");
        }
        catch (XMLSignatureException e) {
            log.error("XML document signature verification failed with an error", (Throwable)e);
            throw new Terminator(ReturnCode.RC_SIG);
        }
    }

    protected static Reference extractReference(XMLSignature signature) {
        Reference ref;
        int numReferences = signature.getSignedInfo().getLength();
        if (numReferences != 1) {
            log.error("Signature SignedInfo had invalid number of References: " + numReferences);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        try {
            ref = signature.getSignedInfo().item(0);
        }
        catch (XMLSecurityException e) {
            log.error("Apache XML Security exception obtaining Reference", (Throwable)e);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        if (ref == null) {
            log.error("Signature Reference was null");
            throw new Terminator(ReturnCode.RC_SIG);
        }
        return ref;
    }

    protected static void validateSignatureReference(Document xmlDocument, Reference ref) {
        XMLSecTool.validateSignatureReferenceUri(xmlDocument, ref);
        XMLSecTool.validateSignatureTransforms(ref);
    }

    protected static void validateSignatureReferenceUri(Document xmlDocument, Reference reference) {
        ReferenceData refData = reference.getReferenceData();
        if (refData instanceof ReferenceSubTreeData) {
            Element expectedSignedNode;
            Node root;
            ReferenceSubTreeData subTree = (ReferenceSubTreeData)refData;
            Node resolvedSignedNode = root = subTree.getRoot();
            if (root.getNodeType() == 9) {
                resolvedSignedNode = ((Document)root).getDocumentElement();
            }
            if (!(expectedSignedNode = xmlDocument.getDocumentElement()).isSameNode(resolvedSignedNode)) {
                log.error("Signature Reference URI \"" + reference.getURI() + "\" was resolved to a node other than the document element");
                throw new Terminator(ReturnCode.RC_SIG);
            }
        } else {
            log.error("Signature Reference URI did not resolve to a subtree");
            throw new Terminator(ReturnCode.RC_SIG);
        }
    }

    protected static void validateSignatureTransforms(Reference reference) {
        Transforms transforms = null;
        try {
            transforms = reference.getTransforms();
        }
        catch (XMLSecurityException e) {
            log.error("Apache XML Security error obtaining Transforms instance", (Throwable)e);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        if (transforms == null) {
            log.error("Error obtaining Transforms instance, null was returned");
            throw new Terminator(ReturnCode.RC_SIG);
        }
        int numTransforms = transforms.getLength();
        if (numTransforms > 2) {
            log.error("Invalid number of Transforms was present: " + numTransforms);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        boolean sawEnveloped = false;
        for (int i = 0; i < numTransforms; ++i) {
            Transform transform = null;
            try {
                transform = transforms.item(i);
            }
            catch (TransformationException e) {
                log.error("Error obtaining transform instance", (Throwable)e);
                throw new Terminator(ReturnCode.RC_SIG);
            }
            String uri = transform.getURI();
            if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(uri)) {
                log.debug("Saw Enveloped signature transform");
                sawEnveloped = true;
                continue;
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(uri) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(uri)) {
                log.debug("Saw Exclusive C14N signature transform");
                continue;
            }
            log.error("Saw invalid signature transform: " + uri);
            throw new Terminator(ReturnCode.RC_SIG);
        }
        if (!sawEnveloped) {
            log.error("Signature was missing the required Enveloped signature transform");
            throw new Terminator(ReturnCode.RC_SIG);
        }
    }

    protected static Element getSignatureElement(Document xmlDoc) {
        List sigElements = ElementSupport.getChildElementsByTagNameNS((Node)xmlDoc.getDocumentElement(), (String)Signature.DEFAULT_ELEMENT_NAME.getNamespaceURI(), (String)Signature.DEFAULT_ELEMENT_NAME.getLocalPart());
        if (sigElements.isEmpty()) {
            return null;
        }
        if (sigElements.size() > 1) {
            log.error("XML document contained more than one signature, unable to process");
            throw new Terminator(ReturnCode.RC_SIG);
        }
        return (Element)sigElements.get(0);
    }

    protected static X509Credential getCredential(CommandLineArguments cli) {
        BasicX509Credential credential;
        if (cli.getCertificate() != null) {
            try {
                credential = CredentialHelper.getFileBasedCredentials(cli.getKeyFile(), cli.getKeyPassword(), cli.getCertificate());
            }
            catch (KeyException e) {
                log.error("Unable to read key file " + cli.getKeyFile(), (Throwable)e);
                throw new Terminator(ReturnCode.RC_IO);
            }
            catch (CertificateException e) {
                log.error("Unable to read certificate file " + cli.getKeyFile(), (Throwable)e);
                throw new Terminator(ReturnCode.RC_IO);
            }
        }
        if (cli.getPkcs11Config() != null) {
            try {
                credential = CredentialHelper.getPKCS11Credential(cli.getPkcs11Config(), cli.getKeyAlias(), cli.getKeyPassword());
            }
            catch (IOException e) {
                log.error("Error accessing PKCS11 store", (Throwable)e);
                throw new Terminator(ReturnCode.RC_IO);
            }
            catch (GeneralSecurityException e) {
                log.error("Unable to recover key entry from PKCS11 store", (Throwable)e);
                throw new Terminator(ReturnCode.RC_IO);
            }
        }
        try {
            credential = CredentialHelper.getKeystoreCredential(cli.getKeystore(), cli.getKeystorePassword(), cli.getKeystoreProvider(), cli.getKeystoreType(), cli.getKeyAlias(), cli.getKeyPassword());
        }
        catch (IOException e) {
            log.error("Unable to read keystore " + cli.getKeystore(), (Throwable)e);
            throw new Terminator(ReturnCode.RC_IO);
        }
        catch (GeneralSecurityException e) {
            log.error("Unable to recover key entry from keystore", (Throwable)e);
            throw new Terminator(ReturnCode.RC_IO);
        }
        if (cli.getKeyInfoKeyNames() != null) {
            credential.getKeyNames().addAll(cli.getKeyInfoKeyNames());
        }
        credential.setCRLs(XMLSecTool.getCRLs(cli));
        return credential;
    }

    protected static Collection<X509CRL> getCRLs(CommandLineArguments cli) {
        List<String> keyInfoCrls = cli.getKeyInfoCrls();
        if (keyInfoCrls == null || keyInfoCrls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        File crlFile = null;
        try {
            for (String crlFilePath : keyInfoCrls) {
                crlFile = new File(crlFilePath);
                if (!crlFile.exists() || !crlFile.canRead()) {
                    log.error("Unable to read CRL file " + crlFilePath);
                    throw new Terminator(ReturnCode.RC_INVALID_CRED);
                }
                crls.addAll(X509Support.decodeCRLs((File)crlFile));
            }
        }
        catch (CRLException e) {
            log.error("Unable to parse CRL file " + crlFile.getAbsolutePath(), (Throwable)e);
            throw new Terminator(ReturnCode.RC_INVALID_CRED);
        }
        return crls;
    }

    protected static void writeDocument(CommandLineArguments cli, Node xml) {
        try {
            log.debug("Attempting to write output to file {}", (Object)cli.getOutputFile());
            File file = new File(cli.getOutputFile());
            if (file.exists() && file.isDirectory()) {
                log.error("Output file " + cli.getOutputFile() + " is a directory");
                throw new Terminator(ReturnCode.RC_IO);
            }
            file.createNewFile();
            if (!file.canWrite()) {
                log.error("Unable to write to output file " + cli.getOutputFile());
                throw new Terminator(ReturnCode.RC_IO);
            }
            OutputStream out = new FileOutputStream(cli.getOutputFile());
            if (cli.isBase64EncodedOutput()) {
                log.debug("Base64 encoding output to file");
                out = new Base64OutputStream(out);
            }
            if (cli.isDeflateOutput()) {
                log.debug("Deflate compressing output to file");
                out = new DeflaterOutputStream(out);
            }
            if (cli.isGzipOutput()) {
                log.debug("GZip compressing output to file");
                out = new GZIPOutputStream(out);
            }
            log.debug("Writing XML document to output file {}", (Object)cli.getOutputFile());
            try {
                TransformerFactory tfac = TransformerFactory.newInstance();
                Transformer serializer = tfac.newTransformer();
                serializer.setOutputProperty("encoding", "UTF-8");
                serializer.transform(new DOMSource(xml), new StreamResult(out));
            }
            catch (TransformerException e) {
                log.error("Unable to write out XML", (Throwable)e);
                throw new Terminator(ReturnCode.RC_IO);
            }
            out.flush();
            out.close();
            log.info("XML document written to file {}", (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("Unable to write document to file " + cli.getOutputFile(), (Throwable)e);
            throw new Terminator(ReturnCode.RC_IO);
        }
    }

    protected static void initLogging(CommandLineArguments cli) {
        if (cli.getLoggingConfiguration() != null) {
            System.setProperty("logback.configurationFile", cli.getLoggingConfiguration());
        } else if (cli.doVerboseOutput()) {
            System.setProperty("logback.configurationFile", "logger-verbose.xml");
        } else if (cli.doQuietOutput()) {
            System.setProperty("logback.configurationFile", "logger-quiet.xml");
        } else {
            System.setProperty("logback.configurationFile", "logger-normal.xml");
        }
        log = LoggerFactory.getLogger(XMLSecTool.class);
    }
}

