/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.ConnectionIdLogger;
import com.tc.net.protocol.NetworkLayer;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportListener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;

public abstract class AbstractMessageTransport
implements MessageTransport {
    private static final int DISCONNECTED = 1;
    private static final int FORCED_DISCONNECT = 2;
    private static final int CONNECTED = 3;
    private static final int CONNECT_ATTEMPT = 4;
    private static final int CLOSED = 5;
    private static final int RECONNECTION_REJECTED = 6;
    protected ConnectionIdLogger logger;
    private final CopyOnWriteArrayList<MessageTransportListener> listeners = new CopyOnWriteArrayList();

    public AbstractMessageTransport(Logger logger) {
        this.logger = new ConnectionIdLogger(this, logger);
    }

    protected ConnectionIdLogger getLogger() {
        return this.logger;
    }

    @Override
    public final void addTransportListeners(List<MessageTransportListener> toAdd) {
        for (MessageTransportListener l : toAdd) {
            this.addTransportListener(l);
        }
    }

    protected List<MessageTransportListener> getTransportListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void addTransportListener(MessageTransportListener listener) {
        if (!this.listeners.addIfAbsent(listener)) {
            throw new AssertionError((Object)("Attempt to add the same listener more than once: " + listener));
        }
    }

    @Override
    public final void removeTransportListeners() {
        this.listeners.clear();
    }

    protected void fireTransportConnectAttemptEvent() {
        this.fireTransportEvent(4);
    }

    protected final void fireTransportConnectedEvent() {
        this.logFireTransportConnectEvent();
        this.fireTransportEvent(3);
    }

    private void logFireTransportConnectEvent() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Firing connect event...");
        }
    }

    protected final void fireTransportForcedDisconnectEvent() {
        this.fireTransportEvent(2);
    }

    protected final void fireTransportDisconnectedEvent() {
        this.fireTransportEvent(1);
    }

    protected final void fireTransportClosedEvent() {
        this.fireTransportEvent(5);
    }

    protected final void fireTransportReconnectionRejectedEvent() {
        this.fireTransportEvent(6);
    }

    private void fireTransportEvent(int type) {
        block8: for (MessageTransportListener listener : this.listeners) {
            switch (type) {
                case 1: {
                    listener.notifyTransportDisconnected(this, false);
                    continue block8;
                }
                case 2: {
                    listener.notifyTransportDisconnected(this, true);
                    continue block8;
                }
                case 3: {
                    listener.notifyTransportConnected(this);
                    continue block8;
                }
                case 4: {
                    listener.notifyTransportConnectAttempt(this);
                    continue block8;
                }
                case 5: {
                    listener.notifyTransportClosed(this);
                    continue block8;
                }
                case 6: {
                    listener.notifyTransportReconnectionRejected(this);
                    continue block8;
                }
            }
            throw new AssertionError((Object)("Unknown transport event: " + type));
        }
    }

    @Override
    public short getCommunicationStackFlags(NetworkLayer parentLayer) {
        short stackLayerFlags = 0;
        while (parentLayer != null) {
            stackLayerFlags = (short)(stackLayerFlags | parentLayer.getStackLayerFlag());
            parentLayer = parentLayer.getReceiveLayer();
        }
        return stackLayerFlags;
    }

    @Override
    public String getCommunicationStackNames(NetworkLayer parentLayer) {
        StringBuilder currentLayer = new StringBuilder();
        while (parentLayer != null) {
            currentLayer.append("\n").append(parentLayer.getStackLayerName());
            parentLayer = parentLayer.getReceiveLayer();
        }
        return currentLayer.toString();
    }
}

