/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;

public class Configuration {
    private static final Collection<String> SETTINGS = Stream.of(Setting.values()).map(Setting::toString).collect(Collectors.toSet());
    private static final Map<Pattern, BiFunction<String, Matcher, Configuration>> CLUSTER_PATTERNS = new LinkedHashMap<Pattern, BiFunction<String, Matcher, Configuration>>();
    private static final Map<Pattern, BiFunction<String, Matcher, Configuration>> STRIPE_PATTERNS = new LinkedHashMap<Pattern, BiFunction<String, Matcher, Configuration>>();
    private static final Map<Pattern, BiFunction<String, Matcher, Configuration>> NODE_PATTERNS = new LinkedHashMap<Pattern, BiFunction<String, Matcher, Configuration>>();
    private static final String GRP_STRIPE = "stripe\\.(\\d+)";
    private static final String GRP_NODE = "node\\.(\\d+)";
    private static final String SEP = "\\.";
    private static final String NS = "[.:]";
    private static final String GRP_SETTING = "([a-z\\-]+)";
    private static final String GRP_KEY = "([^=:]+)";
    private static final String ASSIGN = "=";
    private static final String GRP_VALUE = "([^=]+)";
    private final String rawInput;
    private final Setting setting;
    private final Scope level;
    private final Integer stripeId;
    private final Integer nodeId;
    private final String key;
    private final String value;

    public Configuration(String rawInput, Setting setting, Scope level, Integer stripeId, Integer nodeId, String key, String value) {
        this.rawInput = Objects.requireNonNull(rawInput);
        this.setting = Objects.requireNonNull(setting);
        this.level = Objects.requireNonNull(level);
        this.stripeId = stripeId;
        this.nodeId = nodeId;
        this.key = key;
        this.value = value == null ? null : value.trim();
        this.preValidate();
    }

    public Scope getLevel() {
        return this.level;
    }

    public int getStripeId() {
        return this.stripeId;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public Setting getSetting() {
        return this.setting;
    }

    public String getKey() {
        return this.key;
    }

    public Optional<String> getValue() {
        return this.value == null || this.value.isEmpty() ? Optional.empty() : Optional.of(this.value);
    }

    public boolean hasValue() {
        return this.getValue().isPresent();
    }

    public boolean isSet() {
        return this.value != null;
    }

    private void preValidate() {
        if (!this.setting.isMap() && this.key != null) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' is not a map and must not have a key");
        }
        if (this.stripeId != null && this.stripeId <= 0) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Expected stripe ID to be greater than 0");
        }
        if (this.nodeId != null && this.nodeId <= 0) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Expected node ID to be greater than 0");
        }
        if (!this.setting.allows(this.level)) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Setting '" + (Object)((Object)this.setting) + "' does not allow any operation at " + (Object)((Object)this.level) + " level");
        }
        try {
            this.setting.validate(this.key, this.value, this.level);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: " + e.getMessage(), e);
        }
    }

    public void validate(ClusterState clusterState, Operation operation) {
        try {
            this.setting.validate(this.key, this.value, this.level, clusterState, operation);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: " + e.getMessage(), e);
        }
    }

    public boolean duplicates(Configuration other) throws IllegalArgumentException {
        if (this.setting != other.setting) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (!Objects.equals(this.stripeId, other.stripeId) || !Objects.equals(this.nodeId, other.nodeId)) {
            return false;
        }
        if (!this.setting.isMap()) {
            return true;
        }
        if (this.key != null && other.key != null && Objects.equals(this.key, other.key)) {
            return true;
        }
        if (this.key != null && other.key != null && !Objects.equals(this.key, other.key)) {
            return false;
        }
        if (this.key == null && other.key == null && Objects.equals(this.value, other.value)) {
            return true;
        }
        throw new IllegalArgumentException("Incompatible or duplicate configurations: " + this + " and " + other);
    }

    public boolean matchConfigPropertyKey(String key) {
        Configuration configPropertyKey = Configuration.valueOf(key);
        if (configPropertyKey.setting != this.setting) {
            return false;
        }
        if (this.stripeId != null && !Objects.equals(this.stripeId, configPropertyKey.stripeId)) {
            return false;
        }
        if (this.nodeId != null && !Objects.equals(this.nodeId, configPropertyKey.nodeId)) {
            return false;
        }
        if (this.setting.isMap() && this.key != null && !Objects.equals(this.key, configPropertyKey.key)) {
            return false;
        }
        return !this.setting.isMap() || this.key != null || configPropertyKey.key == null;
    }

    public Collection<? extends PropertyHolder> apply(PropertyHolder propertyHolder) {
        Collection targets = this.findTargets(propertyHolder).collect(Collectors.toList());
        targets.forEach(target -> this.setting.setProperty((PropertyHolder)target, this.key, this.value));
        return targets;
    }

    public int hashCode() {
        return this.rawInput.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.rawInput.equals(that.rawInput);
    }

    public String toString() {
        return this.rawInput;
    }

    public Stream<? extends PropertyHolder> findTargets(PropertyHolder from) {
        Stream<? extends PropertyHolder> targets;
        block0 : switch (this.level) {
            case CLUSTER: {
                switch (from.getScope()) {
                    case CLUSTER: 
                    case STRIPE: 
                    case NODE: {
                        targets = Stream.concat(Stream.of(from), from.descendants());
                        break block0;
                    }
                }
                throw new AssertionError((Object)from.getScope());
            }
            case STRIPE: {
                switch (from.getScope()) {
                    case CLUSTER: {
                        Cluster cluster = (Cluster)from;
                        Stripe stripe = cluster.getStripe(this.stripeId).orElseThrow(() -> new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Invalid stripe ID: " + this.stripeId + ". Cluster contains: " + cluster.getStripeCount() + " stripe(s)"));
                        targets = Stream.concat(Stream.of(stripe), stripe.descendants());
                        break block0;
                    }
                    case STRIPE: 
                    case NODE: {
                        targets = Stream.concat(Stream.of(from), from.descendants());
                        break block0;
                    }
                }
                throw new AssertionError((Object)from.getScope());
            }
            case NODE: {
                switch (from.getScope()) {
                    case CLUSTER: {
                        Cluster cluster = (Cluster)from;
                        Stripe stripe = cluster.getStripe(this.stripeId).orElseThrow(() -> new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Invalid stripe ID: " + this.stripeId + ". Cluster contains: " + cluster.getStripeCount() + " stripe(s)"));
                        Node node = Configuration.getNode(stripe, this.nodeId).orElseThrow(() -> new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Invalid node ID: " + this.nodeId + ". Stripe ID: " + this.stripeId + " contains: " + stripe.getNodeCount() + " node(s)"));
                        targets = Stream.concat(Stream.of(node), node.descendants());
                        break block0;
                    }
                    case STRIPE: {
                        Stripe stripe = (Stripe)from;
                        Node node = Configuration.getNode(stripe, this.nodeId).orElseThrow(() -> new IllegalArgumentException("Invalid input: '" + this.rawInput + "'. Reason: Invalid node ID: " + this.nodeId + ". Stripe ID: " + this.stripeId + " contains: " + stripe.getNodeCount() + " node(s)"));
                        targets = Stream.concat(Stream.of(node), node.descendants());
                        break block0;
                    }
                    case NODE: {
                        targets = Stream.concat(Stream.of(from), from.descendants());
                        break block0;
                    }
                }
                throw new AssertionError((Object)from.getScope());
            }
            default: {
                throw new AssertionError((Object)this.level);
            }
        }
        return targets.filter(ph -> ph.getScope() == this.getSetting().getScope());
    }

    public List<Configuration> expand() {
        if (!this.setting.isMap() || this.key != null || !this.hasValue()) {
            return Collections.singletonList(this);
        }
        String[] keyValue = this.rawInput.split(ASSIGN, 2);
        return Stream.of(keyValue[1].split(",")).filter(s -> !s.trim().isEmpty()).map(s -> {
            String[] nameProperty = s.trim().split(":", 2);
            if (nameProperty.length != 2) {
                throw new IllegalArgumentException("Invalid input: " + this.value);
            }
            return keyValue[0] + "." + nameProperty[0] + ASSIGN + nameProperty[1];
        }).distinct().map(Configuration::valueOf).collect(Collectors.toList());
    }

    public static Configuration valueOf(String key, String value) {
        return Configuration.valueOf(key + ASSIGN + (value == null ? "" : value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Configuration valueOf(String input) {
        Matcher matcher;
        Objects.requireNonNull(input);
        input = input.trim();
        Integer stripeId = null;
        Integer nodeId = null;
        Setting setting = null;
        try (Scanner scanner = new Scanner(input).useDelimiter("[.:=]");){
            block19: while (scanner.hasNext() && setting == null) {
                String next;
                switch (next = scanner.next()) {
                    case "stripe": {
                        if (stripeId != null) {
                            throw new IllegalArgumentException("Invalid input: '" + input + "'");
                        }
                        stripeId = scanner.nextInt(10);
                        continue block19;
                    }
                    case "node": {
                        if (nodeId != null || stripeId == null) {
                            throw new IllegalArgumentException("Invalid input: '" + input + "'");
                        }
                        nodeId = scanner.nextInt(10);
                        continue block19;
                    }
                }
                if (!SETTINGS.contains(next)) {
                    throw new IllegalArgumentException("Invalid input: '" + input + "'. Reason: Invalid setting name: '" + next + "'");
                }
                setting = Setting.fromName(next);
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid input: '" + input + "'");
        }
        if (setting == null) {
            throw new IllegalArgumentException("Invalid input: '" + input + "'. Reason: valid setting name not found");
        }
        if (stripeId != null && nodeId != null) {
            for (Map.Entry<Pattern, BiFunction<String, Matcher, Configuration>> entry : NODE_PATTERNS.entrySet()) {
                matcher = entry.getKey().matcher(input);
                if (!matcher.matches()) continue;
                return entry.getValue().apply(input, matcher);
            }
        }
        if (stripeId != null && nodeId == null) {
            for (Map.Entry<Pattern, BiFunction<String, Matcher, Configuration>> entry : STRIPE_PATTERNS.entrySet()) {
                matcher = entry.getKey().matcher(input);
                if (!matcher.matches()) continue;
                return entry.getValue().apply(input, matcher);
            }
        }
        if (stripeId == null) {
            for (Map.Entry<Pattern, BiFunction<String, Matcher, Configuration>> entry : CLUSTER_PATTERNS.entrySet()) {
                matcher = entry.getKey().matcher(input);
                if (!matcher.matches()) continue;
                return entry.getValue().apply(input, matcher);
            }
        }
        throw new IllegalArgumentException("Invalid input: '" + input + "'");
    }

    private static Optional<Node> getNode(Stripe stripe, int nodeId) {
        if (nodeId < 1) {
            throw new IllegalArgumentException("Invalid node ID: " + nodeId);
        }
        if (nodeId > stripe.getNodeCount()) {
            return Optional.empty();
        }
        return Optional.of(stripe.getNodes().get(nodeId - 1));
    }

    static {
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(4), matcher.group(5)));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), null, matcher.group(4)));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, matcher.group(3), matcher.group(4)));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, null, matcher.group(3)));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)\\.([^=:]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, matcher.group(2), matcher.group(3)));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)=([^=]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, null, matcher.group(2)));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(4), ""));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), null, ""));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, matcher.group(3), ""));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, null, ""));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)\\.([^=:]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, matcher.group(2), ""));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)=$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, null, ""));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(4), null));
        NODE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)\\.node\\.(\\d+)[.:]([a-z\\-]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(3)), Scope.NODE, Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), null, null));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, matcher.group(3), null));
        STRIPE_PATTERNS.put(Pattern.compile("^stripe\\.(\\d+)[.:]([a-z\\-]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(2)), Scope.STRIPE, Integer.parseInt(matcher.group(1)), null, null, null));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)\\.([^=:]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, matcher.group(2), null));
        CLUSTER_PATTERNS.put(Pattern.compile("^([a-z\\-]+)$"), (input, matcher) -> new Configuration((String)input, Setting.fromName(matcher.group(1)), Scope.CLUSTER, null, null, null, null));
    }
}

