/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.eventregistry.impl.persistence.deploy.ChannelDefinitionCacheEntry;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class SetChannelDefinitionCategoryCmd
implements Command<Void> {
    protected String channelDefinitionId;
    protected String category;

    public SetChannelDefinitionCategoryCmd(String channelDefinitionId, String category) {
        this.channelDefinitionId = channelDefinitionId;
        this.category = category;
    }

    public Void execute(CommandContext commandContext) {
        if (this.channelDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Channel definition id is null");
        }
        ChannelDefinitionEntity channelDefinition = (ChannelDefinitionEntity)CommandContextUtil.getChannelDefinitionEntityManager(commandContext).findById(this.channelDefinitionId);
        if (channelDefinition == null) {
            throw new FlowableObjectNotFoundException("No channel definition found for id = '" + this.channelDefinitionId + "'");
        }
        channelDefinition.setCategory(this.category);
        DeploymentCache<ChannelDefinitionCacheEntry> channelDefinitionCache = CommandContextUtil.getEventRegistryConfiguration().getChannelDefinitionCache();
        if (channelDefinitionCache != null) {
            channelDefinitionCache.remove(this.channelDefinitionId);
        }
        CommandContextUtil.getChannelDefinitionEntityManager(commandContext).update(channelDefinition);
        return null;
    }
}

