/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityManager;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.model.ChannelModel;

public class UpdateChannelDefinitionTypeAndImplementationForAllChannelDefinitionsCmd
implements Command<Void> {
    public Void execute(CommandContext commandContext) {
        EventRegistryEngineConfiguration configuration = CommandContextUtil.getEventRegistryConfiguration(commandContext);
        EventRepositoryService repositoryService = configuration.getEventRepositoryService();
        List channelDefinitions = repositoryService.createChannelDefinitionQuery().list();
        ChannelDefinitionEntityManager entityManager = configuration.getChannelDefinitionEntityManager();
        String encoding = configuration.getXmlEncoding();
        Charset encodingCharset = encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            ChannelModel model;
            try (InputStream stream = repositoryService.getResourceAsStream(channelDefinition.getDeploymentId(), channelDefinition.getResourceName());){
                model = configuration.getChannelJsonConverter().convertToChannelModel(IOUtils.toString((InputStream)stream, (Charset)encodingCharset));
            }
            catch (IOException e) {
                throw new FlowableException("Failed to close resource", (Throwable)e);
            }
            entityManager.updateChannelDefinitionTypeAndImplementation(channelDefinition.getId(), model.getChannelType(), model.getType());
        }
        return null;
    }
}

