/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.HasScriptInfo;
import org.flowable.bpmn.model.ScriptInfo;

public class ScriptInfoParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "script";
    }

    @Override
    public boolean accepts(BaseElement element) {
        return element instanceof HasScriptInfo;
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!this.accepts(parentElement)) {
            return;
        }
        if (xtr.isStartElement() && "script".equals(xtr.getLocalName())) {
            String elementText;
            ScriptInfo script = new ScriptInfo();
            BpmnXMLUtil.addXMLLocation((BaseElement)script, xtr);
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "language"))) {
                script.setLanguage(xtr.getAttributeValue(null, "language"));
            }
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "resultVariable"))) {
                script.setResultVariable(xtr.getAttributeValue(null, "resultVariable"));
            }
            if (StringUtils.isNotEmpty((CharSequence)(elementText = xtr.getElementText()))) {
                script.setScript(StringUtils.trim((String)elementText));
            }
            if (parentElement instanceof HasScriptInfo) {
                ((HasScriptInfo)parentElement).setScriptInfo(script);
            }
        }
    }
}

