/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.parser;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnDiEdge;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.GraphicInfo;

public class BpmnEdgeParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String id = xtr.getAttributeValue(null, "bpmnElement");
        ArrayList<GraphicInfo> wayPointList = new ArrayList<GraphicInfo>();
        String sourceDockerX = xtr.getAttributeValue(null, "sourceDockerX");
        String sourceDockerY = xtr.getAttributeValue(null, "sourceDockerY");
        String targetDockerX = xtr.getAttributeValue(null, "targetDockerX");
        String targetDockerY = xtr.getAttributeValue(null, "targetDockerY");
        if (StringUtils.isNotEmpty((CharSequence)sourceDockerX) && StringUtils.isNotEmpty((CharSequence)sourceDockerY) && StringUtils.isNotEmpty((CharSequence)targetDockerX) && StringUtils.isNotEmpty((CharSequence)targetDockerY)) {
            BpmnDiEdge edgeInfo = new BpmnDiEdge();
            edgeInfo.setWaypoints(wayPointList);
            GraphicInfo sourceDockerInfo = new GraphicInfo();
            sourceDockerInfo.setX((double)Double.valueOf(sourceDockerX).intValue());
            sourceDockerInfo.setY((double)Double.valueOf(sourceDockerY).intValue());
            edgeInfo.setSourceDockerInfo(sourceDockerInfo);
            GraphicInfo targetDockerInfo = new GraphicInfo();
            targetDockerInfo.setX((double)Double.valueOf(targetDockerX).intValue());
            targetDockerInfo.setY((double)Double.valueOf(targetDockerY).intValue());
            edgeInfo.setTargetDockerInfo(targetDockerInfo);
            model.addEdgeInfo(id, edgeInfo);
        }
        block0: while (xtr.hasNext()) {
            GraphicInfo graphicInfo;
            xtr.next();
            if (xtr.isStartElement() && "BPMNLabel".equalsIgnoreCase(xtr.getLocalName())) {
                while (xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement() && "Bounds".equalsIgnoreCase(xtr.getLocalName())) {
                        graphicInfo = new GraphicInfo();
                        BpmnXMLUtil.addXMLLocation(graphicInfo, xtr);
                        graphicInfo.setX((double)Double.valueOf(xtr.getAttributeValue(null, "x")).intValue());
                        graphicInfo.setY((double)Double.valueOf(xtr.getAttributeValue(null, "y")).intValue());
                        graphicInfo.setWidth((double)Double.valueOf(xtr.getAttributeValue(null, "width")).intValue());
                        graphicInfo.setHeight((double)Double.valueOf(xtr.getAttributeValue(null, "height")).intValue());
                        model.addLabelGraphicInfo(id, graphicInfo);
                        continue block0;
                    }
                    if (!xtr.isEndElement() || !"BPMNLabel".equalsIgnoreCase(xtr.getLocalName())) continue;
                    continue block0;
                }
                continue;
            }
            if (xtr.isStartElement() && "waypoint".equalsIgnoreCase(xtr.getLocalName())) {
                graphicInfo = new GraphicInfo();
                BpmnXMLUtil.addXMLLocation(graphicInfo, xtr);
                graphicInfo.setX((double)Double.valueOf(xtr.getAttributeValue(null, "x")).intValue());
                graphicInfo.setY((double)Double.valueOf(xtr.getAttributeValue(null, "y")).intValue());
                wayPointList.add(graphicInfo);
                continue;
            }
            if (!xtr.isEndElement() || !"BPMNEdge".equalsIgnoreCase(xtr.getLocalName())) continue;
        }
        model.addFlowGraphicInfoList(id, wayPointList);
    }

    public BaseElement parseElement() {
        return null;
    }
}

