/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.syncope.common.lib.AMSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMSessionDeserializer
extends StdDeserializer<AMSession> {
    private static final long serialVersionUID = 24527200564172L;
    private static final Logger LOG = LoggerFactory.getLogger(AMSessionDeserializer.class);

    public AMSessionDeserializer() {
        this(null);
    }

    public AMSessionDeserializer(Class<?> vc) {
        super(vc);
    }

    public AMSession deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        AMSession waSession = new AMSession();
        if (node.has("authentication_date_formatted")) {
            String authenticationDate = node.get("authentication_date_formatted").textValue();
            try {
                waSession.setAuthenticationDate(OffsetDateTime.parse(authenticationDate, DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            }
            catch (DateTimeParseException e) {
                LOG.error("Unparsable date: {}", (Object)authenticationDate, (Object)e);
            }
        }
        if (node.has("authenticated_principal")) {
            waSession.setPrincipal(node.get("authenticated_principal").textValue());
        }
        if (node.has("ticket_granting_ticket")) {
            waSession.setKey(node.get("ticket_granting_ticket").textValue());
        }
        StringWriter writer = new StringWriter();
        JsonGenerator jgen = jp.getCodec().getFactory().createGenerator((Writer)writer);
        jgen.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        jp.getCodec().writeTree(jgen, (TreeNode)node);
        waSession.setJson(writer.toString());
        return waSession;
    }
}

