/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.OIDCJWKSTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="OpenID Connect 1.0")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="oidc/jwks")
public interface OIDCJWKSService
extends JAXRSService {
    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public OIDCJWKSTO get();

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void set(@NotNull OIDCJWKSTO var1);

    @ApiResponses(value={@ApiResponse(responseCode="201", description="JWKS successfully created", headers={@Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")}), @ApiResponse(responseCode="409", description="JWKS already exists")})
    @POST
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Path(value="new")
    public Response generate(@NotNull @QueryParam(value="jwksKeyId") @DefaultValue(value="syncope") String var1, @NotNull @QueryParam(value="jwksType") @DefaultValue(value="RSA") String var2, @NotNull @QueryParam(value="jwksKeySize") @DefaultValue(value="2048") int var3);

    @DELETE
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete();
}

