/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public final class RemoteWrappedException
extends ConnectorException {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_CLASS = "class";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_CAUSE = "cause";
    public static final String FIELD_STACK_TRACE = "stackTrace";
    private final String stackTrace;
    private Map<String, Object> exception = null;

    RemoteWrappedException(Map<String, Object> exception) {
        super((String)exception.get(FIELD_MESSAGE));
        this.exception = exception;
        this.stackTrace = (String)exception.get(FIELD_STACK_TRACE);
    }

    public RemoteWrappedException(String throwableClass, String message, RemoteWrappedException cause, String stackTrace) {
        super(message);
        this.exception = new HashMap<String, Object>(4);
        this.exception.put(FIELD_CLASS, Assertions.blankChecked((String)throwableClass, (String)"throwableClass"));
        this.exception.put(FIELD_MESSAGE, message);
        if (null != cause) {
            this.exception.put(FIELD_CAUSE, cause.exception);
        }
        if (null != stackTrace) {
            this.exception.put(FIELD_STACK_TRACE, stackTrace);
        }
        this.stackTrace = stackTrace;
    }

    public String getExceptionClass() {
        return (String)this.exception.get(FIELD_CLASS);
    }

    public boolean is(Class<? extends Throwable> expected) {
        if (null == expected) {
            return false;
        }
        String className = (String)this.exception.get(FIELD_CLASS);
        String classExpected = expected.getName();
        return classExpected.equalsIgnoreCase(className);
    }

    public RemoteWrappedException getCause() {
        Object o = this.exception.get(FIELD_CAUSE);
        if (o instanceof Map) {
            return new RemoteWrappedException((Map)o);
        }
        return null;
    }

    public void printStackTrace(PrintStream s) {
        if (null == this.stackTrace) {
            super.printStackTrace(s);
        } else {
            s.println(this.stackTrace);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (null == this.stackTrace) {
            super.printStackTrace(s);
        } else {
            s.println(this.stackTrace);
        }
    }

    public String readStackTrace() {
        return this.stackTrace;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.getBuffer().toString();
    }

    public static RemoteWrappedException wrap(Throwable ex) {
        if (null == ex) {
            return null;
        }
        if (ex instanceof RemoteWrappedException) {
            return (RemoteWrappedException)((Object)ex);
        }
        return new RemoteWrappedException(RemoteWrappedException.convert(ex));
    }

    public static HashMap<String, Object> convert(Throwable throwable) {
        HashMap<String, Object> exception = null;
        if (null != throwable) {
            exception = new HashMap<String, Object>(4);
            exception.put(FIELD_CLASS, throwable.getClass().getName());
            exception.put(FIELD_MESSAGE, throwable.getMessage());
            if (null != throwable.getCause()) {
                exception.put(FIELD_CAUSE, RemoteWrappedException.buildCause(throwable.getCause()));
            }
            exception.put(FIELD_STACK_TRACE, RemoteWrappedException.getStackTrace(throwable));
        }
        return exception;
    }

    private static Map<String, Object> buildCause(Throwable throwable) {
        HashMap<String, Object> cause = new HashMap<String, Object>(null != throwable.getCause() ? 3 : 2);
        cause.put(FIELD_CLASS, throwable.getClass().getName());
        cause.put(FIELD_MESSAGE, throwable.getMessage());
        if (null != throwable.getCause()) {
            cause.put(FIELD_CAUSE, RemoteWrappedException.buildCause(throwable.getCause()));
        }
        return cause;
    }
}

