/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.spel;

import java.util.List;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.spel.EvaluationContextFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

public class SimpleEvaluationContextFactory
implements EvaluationContextFactory {
    private static final PropertyAccessor dataBindingPropertyAccessor = DataBindingPropertyAccessor.forReadWriteAccess();
    private final List<PropertyAccessor> propertyAccessors;
    private final ConversionService conversionService;

    public SimpleEvaluationContextFactory(List<PropertyAccessor> propertyAccessors, ConversionService conversionService) {
        this.propertyAccessors = propertyAccessors;
        this.conversionService = conversionService;
    }

    @Override
    public EvaluationContext createContext(Object rootObject) {
        return SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])this.getAccessorsArray()).withConversionService(this.conversionService.getDelegateConversionService()).withRootObject(rootObject).build();
    }

    private PropertyAccessor[] getAccessorsArray() {
        int length = this.propertyAccessors.size() + 1;
        PropertyAccessor[] result = this.propertyAccessors.toArray(new PropertyAccessor[length]);
        result[length - 1] = dataBindingPropertyAccessor;
        return result;
    }
}

