/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.AccessControlService;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckAccess
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckAccess.class);
    @NonnullAfterInit
    private AccessControlService service;
    @Nonnull
    private Function<ProfileRequestContext, String> policyNameLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> operationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, String> resourceLookupStrategy = FunctionSupport.constant(null);

    public void setAccessControlService(@Nonnull AccessControlService acs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.service = (AccessControlService)Constraint.isNotNull((Object)acs, (String)"AccessControlService cannot be null");
    }

    public void setPolicyNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.policyNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy lookup strategy cannot be null");
    }

    public void setPolicyName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.policyNameLookupStrategy = FunctionSupport.constant((Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Policy name cannot be null or empty")));
    }

    public void setOperationLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.operationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy lookup strategy cannot be null");
    }

    public void setOperation(@Nullable String op) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.operationLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)op));
    }

    public void setResourceLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resourceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy lookup strategy cannot be null");
    }

    public void setResource(@Nullable String res) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resourceLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)res));
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.service == null) {
            throw new ComponentInitializationException("AccessControlService cannot be null");
        }
    }

    public boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} HttpServletRequest was null, disallowing access", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return false;
        }
        return true;
    }

    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String policyName = this.policyNameLookupStrategy.apply(profileRequestContext);
        if (policyName == null) {
            this.log.warn("{} No policy name returned by lookup strategy, disallowing access", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        } else if (!this.service.getInstance(policyName).checkAccess((ServletRequest)this.getHttpServletRequest(), this.operationLookupStrategy.apply(profileRequestContext), this.resourceLookupStrategy.apply(profileRequestContext))) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        }
    }
}

