/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.column;

import com.googlecode.wicket.kendo.ui.datatable.column.PropertyColumn;
import com.googlecode.wicket.kendo.ui.utils.KendoDateTimeUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.wicket.model.IModel;

public class DatePropertyColumn
extends PropertyColumn {
    private static final long serialVersionUID = 1L;

    public DatePropertyColumn(String title) {
        super(title);
    }

    public DatePropertyColumn(String title, int width) {
        super(title, width);
    }

    public DatePropertyColumn(String title, String property) {
        super(title, property);
    }

    public DatePropertyColumn(String title, String property, int width) {
        super(title, property, width);
    }

    public DatePropertyColumn(IModel<String> title, String property) {
        super(title, property);
    }

    public DatePropertyColumn(IModel<String> title, String property, int width) {
        super(title, property, width);
    }

    @Override
    public String getType() {
        return "date";
    }

    @Override
    public String getFormat() {
        return "{0:yyyy-MM-dd}";
    }

    @Override
    public String getValue(Object object) {
        Object date = super.getValue(object);
        if (date instanceof Date) {
            return KendoDateTimeUtils.toString((Date)date);
        }
        if (date instanceof LocalDate) {
            return KendoDateTimeUtils.toString((LocalDate)date);
        }
        if (date instanceof LocalDateTime) {
            return KendoDateTimeUtils.toString((LocalDateTime)date);
        }
        return null;
    }
}

