/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.multiselect.lazy;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.behavior.ChoiceModelBehavior;
import com.googlecode.wicket.jquery.core.event.ISelectionChangedListener;
import com.googlecode.wicket.jquery.core.event.SelectionChangedAdapter;
import com.googlecode.wicket.jquery.core.renderer.IChoiceRenderer;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.form.multiselect.lazy.MultiSelectBehavior;
import com.googlecode.wicket.kendo.ui.renderer.ChoiceRenderer;
import com.googlecode.wicket.kendo.ui.template.KendoTemplateBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Generics;

public abstract class MultiSelect<T>
extends FormComponent<Collection<T>>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private List<T> choices = null;
    private ChoiceModelBehavior<T> choiceModelBehavior;
    private IChoiceRenderer<? super T> renderer;
    private final IJQueryTemplate template;
    private KendoTemplateBehavior templateBehavior = null;
    private int width = 0;

    protected MultiSelect(String id) {
        this(id, new ChoiceRenderer());
    }

    protected MultiSelect(String id, IModel<? extends Collection<T>> model) {
        this(id, model, new ChoiceRenderer());
    }

    protected MultiSelect(String id, IChoiceRenderer<? super T> renderer) {
        super(id);
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    protected MultiSelect(String id, IModel<? extends Collection<T>> model, IChoiceRenderer<? super T> renderer) {
        super(id, model);
        this.renderer = renderer;
        this.template = this.newTemplate();
    }

    public final List<T> getChoices() {
        if (this.choices != null) {
            return this.choices;
        }
        return Collections.emptyList();
    }

    protected CharSequence getCallbackUrl() {
        return this.choiceModelBehavior.getCallbackUrl();
    }

    public String getTemplateToken() {
        if (this.templateBehavior != null) {
            return this.templateBehavior.getToken();
        }
        return null;
    }

    public int getListWidth() {
        return this.width;
    }

    public MultiSelect<T> setListWidth(int width) {
        this.width = width;
        return this;
    }

    private List<T> internalGetChoices(String input) {
        this.choices = this.getChoices(input);
        return this.choices;
    }

    protected abstract List<T> getChoices(String var1);

    public void convertInput() {
        ArrayList list = Generics.newArrayList();
        String[] values = this.getInputAsArray();
        if (values != null) {
            for (String value : values) {
                for (T choice : this.choices) {
                    if (!this.renderer.getValue(choice).equals(value)) continue;
                    list.add(choice);
                }
            }
        }
        this.setConvertedInput(list);
    }

    public void updateModel() {
        FormComponent.updateCollectionModel((FormComponent)this);
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoMultiSelect");
    }

    public void refresh(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("var $w = %s; if ($w) { $w.dataSource.read(); }", this.widget()));
    }

    protected String getModelValue() {
        ArrayList values = Generics.newArrayList();
        for (Object value : (Collection)this.getModelObject()) {
            values.add(String.valueOf(this.renderer.render(value)));
        }
        return ((Object)values).toString();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.choiceModelBehavior = this.newChoiceModelBehavior();
        this.add(new Behavior[]{this.choiceModelBehavior});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
        if (this.template != null) {
            this.templateBehavior = new KendoTemplateBehavior(this.template);
            this.add(new Behavior[]{this.templateBehavior});
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "select");
        super.onComponentTag(tag);
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("value", (Object)this.getModelValue());
        behavior.setOption("dataTextField", (Object)Options.asString((String)this.renderer.getTextField()));
        behavior.setOption("dataValueField", (Object)Options.asString((String)this.renderer.getValueField()));
        if (this.templateBehavior != null) {
            behavior.setOption("template", (Object)String.format("jQuery('#%s').html()", this.getTemplateToken()));
        }
        if (this.getListWidth() > 0) {
            behavior.setOption("open", (Object)String.format("function(e) { e.sender.list.width(%d); }", this.getListWidth()));
        }
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new MultiSelectBehavior(selector, (ISelectionChangedListener)new SelectionChangedAdapter()){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getDataSourceUrl() {
                return MultiSelect.this.getCallbackUrl();
            }

            @Override
            protected void onConfigure(KendoDataSource dataSource) {
                MultiSelect.this.onConfigure(dataSource);
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    protected ChoiceModelBehavior<T> newChoiceModelBehavior() {
        return new ChoiceModelBehavior<T>((ITextRenderer)this.renderer, this.template){
            private static final long serialVersionUID = 1L;

            public List<T> getChoices() {
                String input = RequestCycleUtils.getQueryParameterValue((String)"filter[filters][0][value]").toString("");
                return MultiSelect.this.internalGetChoices(input);
            }
        };
    }
}

