/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.factory;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteria;

class ConditionalFlowExecutionListenerHolder {
    private FlowExecutionListener listener;
    private Set<FlowExecutionListenerCriteria> criteriaSet = new LinkedHashSet<FlowExecutionListenerCriteria>(3);

    public ConditionalFlowExecutionListenerHolder(FlowExecutionListener listener) {
        Assert.notNull((Object)listener, (String)"The listener is required");
        this.listener = listener;
    }

    public FlowExecutionListener getListener() {
        return this.listener;
    }

    public void add(FlowExecutionListenerCriteria criteria) {
        this.criteriaSet.add(criteria);
    }

    public void remove(FlowExecutionListenerCriteria criteria) {
        this.criteriaSet.remove(criteria);
    }

    public boolean isCriteriaSetEmpty() {
        return this.criteriaSet.isEmpty();
    }

    public boolean listenerAppliesTo(FlowDefinition flowDefinition) {
        for (FlowExecutionListenerCriteria criteria : this.criteriaSet) {
            if (!criteria.appliesTo(flowDefinition)) continue;
            return true;
        }
        return false;
    }
}

