/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDTOTPBindRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SingleUseTOTPBindRequest
extends UnboundIDTOTPBindRequest {
    private static final long serialVersionUID = -4429898810534930296L;
    @NotNull
    private final String totpPassword;

    public SingleUseTOTPBindRequest(@NotNull String authenticationID, @Nullable String authorizationID, @NotNull String totpPassword, @Nullable String staticPassword, Control ... controls) {
        super(authenticationID, authorizationID, staticPassword, controls);
        Validator.ensureNotNull(totpPassword);
        this.totpPassword = totpPassword;
    }

    public SingleUseTOTPBindRequest(@NotNull String authenticationID, @Nullable String authorizationID, @NotNull String totpPassword, @Nullable byte[] staticPassword, Control ... controls) {
        super(authenticationID, authorizationID, staticPassword, controls);
        Validator.ensureNotNull(totpPassword);
        this.totpPassword = totpPassword;
    }

    private SingleUseTOTPBindRequest(@NotNull String authenticationID, @Nullable String authorizationID, @NotNull String totpPassword, @Nullable ASN1OctetString staticPassword, Control ... controls) {
        super(authenticationID, authorizationID, staticPassword, controls);
        Validator.ensureNotNull(totpPassword);
        this.totpPassword = totpPassword;
    }

    @NotNull
    public static SingleUseTOTPBindRequest decodeSASLCredentials(@NotNull ASN1OctetString saslCredentials, Control ... controls) throws LDAPException {
        try {
            String authenticationID = null;
            String authorizationID = null;
            String totpPassword = null;
            ASN1OctetString staticPassword = null;
            ASN1Sequence s = ASN1Sequence.decodeAsSequence(saslCredentials.getValue());
            block8: for (ASN1Element e : s.elements()) {
                switch (e.getType()) {
                    case -128: {
                        authenticationID = e.decodeAsOctetString().stringValue();
                        continue block8;
                    }
                    case -127: {
                        authorizationID = e.decodeAsOctetString().stringValue();
                        continue block8;
                    }
                    case -126: {
                        totpPassword = e.decodeAsOctetString().stringValue();
                        continue block8;
                    }
                    case -125: {
                        staticPassword = e.decodeAsOctetString();
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_SINGLE_USE_TOTP_DECODE_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            if (authenticationID == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_SINGLE_USE_TOTP_DECODE_MISSING_AUTHN_ID.get());
            }
            if (totpPassword == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_SINGLE_USE_TOTP_DECODE_MISSING_TOTP_PW.get());
            }
            return new SingleUseTOTPBindRequest(authenticationID, authorizationID, totpPassword, staticPassword, controls);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_SINGLE_USE_TOTP_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String getTOTPPassword() {
        return this.totpPassword;
    }

    @Override
    @NotNull
    protected ASN1OctetString getSASLCredentials() {
        return SingleUseTOTPBindRequest.encodeCredentials(this.getAuthenticationID(), this.getAuthorizationID(), this.totpPassword, this.getStaticPassword());
    }

    @Override
    @Nullable
    public SingleUseTOTPBindRequest getRebindRequest(@NotNull String host, int port) {
        return null;
    }

    @Override
    @NotNull
    public SingleUseTOTPBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public SingleUseTOTPBindRequest duplicate(@Nullable Control[] controls) {
        SingleUseTOTPBindRequest bindRequest = new SingleUseTOTPBindRequest(this.getAuthenticationID(), this.getAuthorizationID(), this.totpPassword, this.getStaticPassword(), controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        bindRequest.setIntermediateResponseListener(this.getIntermediateResponseListener());
        bindRequest.setReferralDepth(this.getReferralDepth());
        bindRequest.setReferralConnector(this.getReferralConnectorInternal());
        return bindRequest;
    }

    @Override
    public void toCode(@NotNull List<String> lineList, @NotNull String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(5);
        constructorArgs.add(ToCodeArgHelper.createString(this.getAuthenticationID(), "Authentication ID"));
        constructorArgs.add(ToCodeArgHelper.createString(this.getAuthorizationID(), "Authorization ID"));
        constructorArgs.add(ToCodeArgHelper.createString("---redacted-totp-password---", "TOTP Password"));
        constructorArgs.add(ToCodeArgHelper.createString(this.getStaticPassword() == null ? "null" : "---redacted-static-password---", "Static Password"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "SingleUseTOTPBindRequest", requestID + "Request", "new SingleUseTOTPBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

