/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.action;

import java.util.HashMap;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogatePrincipalBuilder;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SurrogateSelectionAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateSelectionAction.class);
    public static final String PARAMETER_NAME_SURROGATE_TARGET = "surrogateTarget";
    private final SurrogatePrincipalBuilder surrogatePrincipalBuilder;

    @Audit(action="SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION", actionResolverName="SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_ACTION_RESOLVER", resourceResolverName="SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_RESOURCE_RESOLVER")
    protected Event doExecute(RequestContext requestContext) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            Credential credential = WebUtils.getCredential((RequestContext)requestContext);
            if (credential instanceof UsernamePasswordCredential) {
                String target = requestContext.getExternalContext().getRequestParameterMap().get(PARAMETER_NAME_SURROGATE_TARGET);
                LOGGER.debug("Located surrogate target as [{}]", (Object)target);
                if (StringUtils.isNotBlank((CharSequence)target)) {
                    Authentication currentAuth = WebUtils.getAuthentication((RequestContext)requestContext);
                    AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)currentAuth);
                    resultMap.put(PARAMETER_NAME_SURROGATE_TARGET, target);
                    RegisteredService registeredService = WebUtils.getRegisteredService((RequestContext)requestContext);
                    AuthenticationResultBuilder builder = WebUtils.getAuthenticationResultBuilder((RequestContext)requestContext);
                    Optional result = this.surrogatePrincipalBuilder.buildSurrogateAuthenticationResult(builder, credential, target, registeredService);
                    result.ifPresent(bldr -> WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)bldr, (RequestContext)requestContext));
                } else {
                    LOGGER.warn("No surrogate identifier was selected or provided");
                }
                resultMap.put("primary", credential.getId());
            } else {
                LOGGER.debug("Current credential in the webflow is not one of [{}]", (Object)UsernamePasswordCredential.class.getName());
            }
            return this.success(resultMap);
        }
        catch (Exception e) {
            WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)"screen.surrogates.account.selection.error", (String)"Unable to accept or authorize selection");
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.error(e);
        }
    }

    @Generated
    public SurrogateSelectionAction(SurrogatePrincipalBuilder surrogatePrincipalBuilder) {
        this.surrogatePrincipalBuilder = surrogatePrincipalBuilder;
    }
}

